/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.dev.failsafe;

import com.contrastsecurity.thirdparty.dev.failsafe.DelayablePolicyConfig;
import com.contrastsecurity.thirdparty.dev.failsafe.event.EventListener;
import com.contrastsecurity.thirdparty.dev.failsafe.event.ExecutionAttemptedEvent;
import com.contrastsecurity.thirdparty.dev.failsafe.event.ExecutionCompletedEvent;
import com.contrastsecurity.thirdparty.dev.failsafe.event.ExecutionScheduledEvent;
import com.contrastsecurity.thirdparty.dev.failsafe.function.CheckedBiPredicate;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;

public class RetryPolicyConfig<R>
extends DelayablePolicyConfig<R> {
    Duration delayMin;
    Duration delayMax;
    double delayFactor;
    Duration maxDelay;
    Duration jitter;
    double jitterFactor;
    Duration maxDuration;
    int maxRetries;
    List<CheckedBiPredicate<R, Throwable>> abortConditions;
    EventListener<ExecutionCompletedEvent<R>> abortListener;
    EventListener<ExecutionAttemptedEvent<R>> failedAttemptListener;
    EventListener<ExecutionCompletedEvent<R>> retriesExceededListener;
    EventListener<ExecutionAttemptedEvent<R>> retryListener;
    EventListener<ExecutionScheduledEvent<R>> retryScheduledListener;

    RetryPolicyConfig() {
    }

    RetryPolicyConfig(RetryPolicyConfig<R> retryPolicyConfig) {
        super(retryPolicyConfig);
        this.delayMin = retryPolicyConfig.delayMin;
        this.delayMax = retryPolicyConfig.delayMax;
        this.delayFactor = retryPolicyConfig.delayFactor;
        this.maxDelay = retryPolicyConfig.maxDelay;
        this.jitter = retryPolicyConfig.jitter;
        this.jitterFactor = retryPolicyConfig.jitterFactor;
        this.maxDuration = retryPolicyConfig.maxDuration;
        this.maxRetries = retryPolicyConfig.maxRetries;
        this.abortConditions = new ArrayList<CheckedBiPredicate<R, Throwable>>(retryPolicyConfig.abortConditions);
        this.abortListener = retryPolicyConfig.abortListener;
        this.failedAttemptListener = retryPolicyConfig.failedAttemptListener;
        this.retriesExceededListener = retryPolicyConfig.retriesExceededListener;
        this.retryListener = retryPolicyConfig.retryListener;
        this.retryScheduledListener = retryPolicyConfig.retryScheduledListener;
    }

    public boolean allowsRetries() {
        int n2 = this.getMaxRetries();
        Duration duration = this.getMaxDuration();
        return !(n2 != -1 && n2 <= 0 || duration != null && duration.toNanos() <= 0L);
    }

    public List<CheckedBiPredicate<R, Throwable>> getAbortConditions() {
        return this.abortConditions;
    }

    @Override
    public Duration getDelay() {
        return super.getDelay();
    }

    public Duration getDelayMin() {
        return this.delayMin;
    }

    public Duration getDelayMax() {
        return this.delayMax;
    }

    public double getDelayFactor() {
        return this.delayFactor;
    }

    public Duration getJitter() {
        return this.jitter;
    }

    public double getJitterFactor() {
        return this.jitterFactor;
    }

    public int getMaxAttempts() {
        return this.maxRetries == -1 ? -1 : this.maxRetries + 1;
    }

    public Duration getMaxDelay() {
        return this.maxDelay;
    }

    public Duration getMaxDuration() {
        return this.maxDuration;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public EventListener<ExecutionCompletedEvent<R>> getAbortListener() {
        return this.abortListener;
    }

    public EventListener<ExecutionAttemptedEvent<R>> getFailedAttemptListener() {
        return this.failedAttemptListener;
    }

    public EventListener<ExecutionCompletedEvent<R>> getRetriesExceededListener() {
        return this.retriesExceededListener;
    }

    public EventListener<ExecutionAttemptedEvent<R>> getRetryListener() {
        return this.retryListener;
    }

    public EventListener<ExecutionScheduledEvent<R>> getRetryScheduledListener() {
        return this.retryScheduledListener;
    }
}

