/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.dev.failsafe.internal;

import com.contrastsecurity.thirdparty.dev.failsafe.Bulkhead;
import com.contrastsecurity.thirdparty.dev.failsafe.BulkheadConfig;
import com.contrastsecurity.thirdparty.dev.failsafe.internal.BulkheadExecutor;
import com.contrastsecurity.thirdparty.dev.failsafe.internal.util.FutureLinkedList;
import com.contrastsecurity.thirdparty.dev.failsafe.spi.PolicyExecutor;
import java.time.Duration;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class BulkheadImpl<R>
implements Bulkhead<R> {
    private static final CompletableFuture<Void> NULL_FUTURE = CompletableFuture.completedFuture(null);
    private final BulkheadConfig<R> config;
    private final int maxPermits;
    private int permits;
    private final FutureLinkedList futures = new FutureLinkedList();

    public BulkheadImpl(BulkheadConfig<R> bulkheadConfig) {
        this.config = bulkheadConfig;
        this.permits = this.maxPermits = bulkheadConfig.getMaxConcurrency();
    }

    @Override
    public BulkheadConfig<R> getConfig() {
        return this.config;
    }

    @Override
    public void acquirePermit() throws InterruptedException {
        try {
            this.acquirePermitAsync().get();
        }
        catch (CancellationException | ExecutionException exception) {
            // empty catch block
        }
    }

    @Override
    public synchronized boolean tryAcquirePermit() {
        if (this.permits > 0) {
            --this.permits;
            return true;
        }
        return false;
    }

    @Override
    public boolean tryAcquirePermit(Duration duration) throws InterruptedException {
        CompletableFuture<Void> completableFuture = this.acquirePermitAsync();
        if (completableFuture == NULL_FUTURE) {
            return true;
        }
        try {
            completableFuture.get(duration.toNanos(), TimeUnit.NANOSECONDS);
            return true;
        }
        catch (CancellationException | ExecutionException | TimeoutException exception) {
            return false;
        }
    }

    synchronized CompletableFuture<Void> acquirePermitAsync() {
        if (this.permits > 0) {
            --this.permits;
            return NULL_FUTURE;
        }
        return this.futures.add();
    }

    @Override
    public synchronized void releasePermit() {
        if (this.permits < this.maxPermits) {
            ++this.permits;
            CompletableFuture<Void> completableFuture = this.futures.pollFirst();
            if (completableFuture != null) {
                completableFuture.complete(null);
            }
        }
    }

    @Override
    public PolicyExecutor<R> toExecutor(int n2) {
        return new BulkheadExecutor(this, n2);
    }
}

