/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.dev.failsafe.internal;

import com.contrastsecurity.thirdparty.dev.failsafe.CircuitBreaker;
import com.contrastsecurity.thirdparty.dev.failsafe.CircuitBreakerConfig;
import com.contrastsecurity.thirdparty.dev.failsafe.ExecutionContext;
import com.contrastsecurity.thirdparty.dev.failsafe.internal.CircuitBreakerImpl;
import com.contrastsecurity.thirdparty.dev.failsafe.internal.CircuitState;
import com.contrastsecurity.thirdparty.dev.failsafe.internal.CircuitStats;

class ClosedState<R>
extends CircuitState<R> {
    public ClosedState(CircuitBreakerImpl<R> circuitBreakerImpl) {
        super(circuitBreakerImpl, CircuitStats.create(circuitBreakerImpl, ClosedState.capacityFor(circuitBreakerImpl), true, null));
    }

    @Override
    public boolean tryAcquirePermit() {
        return true;
    }

    @Override
    public CircuitBreaker.State getState() {
        return CircuitBreaker.State.CLOSED;
    }

    @Override
    public synchronized void handleConfigChange() {
        this.stats = CircuitStats.create(this.breaker, ClosedState.capacityFor(this.breaker), true, this.stats);
    }

    @Override
    synchronized void checkThreshold(ExecutionContext<R> executionContext) {
        double d2;
        if (this.stats.getExecutionCount() >= this.config.getFailureExecutionThreshold() && ((d2 = (double)this.config.getFailureRateThreshold()) != 0.0 && (double)this.stats.getFailureRate() >= d2 || d2 == 0.0 && this.stats.getFailureCount() >= this.config.getFailureThreshold())) {
            this.breaker.open(executionContext);
        }
    }

    private static int capacityFor(CircuitBreaker<?> circuitBreaker) {
        if (((CircuitBreakerConfig)circuitBreaker.getConfig()).getFailureExecutionThreshold() != 0) {
            return ((CircuitBreakerConfig)circuitBreaker.getConfig()).getFailureExecutionThreshold();
        }
        return ((CircuitBreakerConfig)circuitBreaker.getConfig()).getFailureThresholdingCapacity();
    }
}

