/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.dev.failsafe.internal;

import com.contrastsecurity.thirdparty.dev.failsafe.CircuitBreaker;
import com.contrastsecurity.thirdparty.dev.failsafe.CircuitBreakerConfig;
import com.contrastsecurity.thirdparty.dev.failsafe.ExecutionContext;
import com.contrastsecurity.thirdparty.dev.failsafe.internal.CircuitBreakerImpl;
import com.contrastsecurity.thirdparty.dev.failsafe.internal.CircuitState;
import com.contrastsecurity.thirdparty.dev.failsafe.internal.CircuitStats;
import java.util.concurrent.atomic.AtomicInteger;

class HalfOpenState<R>
extends CircuitState<R> {
    protected final AtomicInteger permittedExecutions = new AtomicInteger();

    public HalfOpenState(CircuitBreakerImpl<R> circuitBreakerImpl) {
        super(circuitBreakerImpl, CircuitStats.create(circuitBreakerImpl, HalfOpenState.capacityFor(circuitBreakerImpl), false, null));
        this.permittedExecutions.set(HalfOpenState.capacityFor(circuitBreakerImpl));
    }

    @Override
    public boolean tryAcquirePermit() {
        return this.permittedExecutions.getAndUpdate(n2 -> n2 == 0 ? 0 : n2 - 1) > 0;
    }

    @Override
    public void releasePermit() {
        this.permittedExecutions.incrementAndGet();
    }

    @Override
    public CircuitBreaker.State getState() {
        return CircuitBreaker.State.HALF_OPEN;
    }

    @Override
    public synchronized void handleConfigChange() {
        this.stats = CircuitStats.create(this.breaker, HalfOpenState.capacityFor(this.breaker), false, this.stats);
    }

    @Override
    synchronized void checkThreshold(ExecutionContext<R> executionContext) {
        boolean bl;
        boolean bl2;
        int n2 = this.config.getSuccessThreshold();
        if (n2 != 0) {
            int n3 = this.config.getSuccessThresholdingCapacity();
            bl2 = this.stats.getSuccessCount() >= n2;
            bl = this.stats.getFailureCount() > n3 - n2;
        } else {
            int n4 = this.config.getFailureRateThreshold();
            if (n4 != 0) {
                boolean bl3 = this.stats.getExecutionCount() >= this.config.getFailureExecutionThreshold();
                bl = bl3 && this.stats.getFailureRate() >= n4;
                bl2 = bl3 && this.stats.getSuccessRate() > 100 - n4;
            } else {
                int n5 = this.config.getFailureThresholdingCapacity();
                int n6 = this.config.getFailureThreshold();
                bl = this.stats.getFailureCount() >= n6;
                boolean bl4 = bl2 = this.stats.getSuccessCount() > n5 - n6;
            }
        }
        if (bl2) {
            this.breaker.close();
        } else if (bl) {
            this.breaker.open(executionContext);
        }
    }

    private static int capacityFor(CircuitBreaker<?> circuitBreaker) {
        int n2 = ((CircuitBreakerConfig)circuitBreaker.getConfig()).getSuccessThresholdingCapacity();
        if (n2 == 0) {
            n2 = ((CircuitBreakerConfig)circuitBreaker.getConfig()).getFailureExecutionThreshold();
        }
        if (n2 == 0) {
            n2 = ((CircuitBreakerConfig)circuitBreaker.getConfig()).getFailureThresholdingCapacity();
        }
        return n2;
    }
}

