/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.dev.failsafe.internal;

import com.contrastsecurity.thirdparty.dev.failsafe.CircuitBreaker;
import com.contrastsecurity.thirdparty.dev.failsafe.internal.CircuitBreakerImpl;
import com.contrastsecurity.thirdparty.dev.failsafe.internal.CircuitState;
import java.time.Duration;

class OpenState<R>
extends CircuitState<R> {
    private final long startTime = System.nanoTime();
    private final long delayNanos;

    public OpenState(CircuitBreakerImpl<R> circuitBreakerImpl, CircuitState<R> circuitState, Duration duration) {
        super(circuitBreakerImpl, circuitState.stats);
        this.delayNanos = duration.toNanos();
    }

    @Override
    public boolean tryAcquirePermit() {
        if (System.nanoTime() - this.startTime >= this.delayNanos) {
            this.breaker.halfOpen();
            return this.breaker.tryAcquirePermit();
        }
        return false;
    }

    @Override
    public Duration getRemainingDelay() {
        long l2 = System.nanoTime() - this.startTime;
        long l3 = this.delayNanos - l2;
        return Duration.ofNanos(Math.max(l3, 0L));
    }

    @Override
    public CircuitBreaker.State getState() {
        return CircuitBreaker.State.OPEN;
    }
}

