/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.dev.failsafe.spi;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;

public final class ExecutionResult<R> {
    private static final CompletableFuture<?> NULL_FUTURE = CompletableFuture.completedFuture(null);
    private static final ExecutionResult<?> NONE = new ExecutionResult<Object>(null, null, true, 0L, true, true, true);
    private final R result;
    private final Throwable exception;
    private final boolean nonResult;
    private final long delayNanos;
    private final boolean complete;
    private final boolean success;
    private final Boolean successAll;

    public ExecutionResult(R r2, Throwable throwable) {
        this(r2, throwable, false, 0L, true, throwable == null, throwable == null);
    }

    private ExecutionResult(R r2, Throwable throwable, boolean bl, long l2, boolean bl2, boolean bl3, Boolean bl4) {
        this.nonResult = bl;
        this.result = r2;
        this.exception = throwable;
        this.delayNanos = l2;
        this.complete = bl2;
        this.success = bl3;
        this.successAll = bl4;
    }

    public static <R> CompletableFuture<ExecutionResult<R>> nullFuture() {
        return NULL_FUTURE;
    }

    public static <R> ExecutionResult<R> success(R r2) {
        return new ExecutionResult<R>(r2, null, false, 0L, true, true, true);
    }

    public static <R> ExecutionResult<R> exception(Throwable throwable) {
        return new ExecutionResult<Object>(null, throwable, false, 0L, true, false, false);
    }

    public static <R> ExecutionResult<R> none() {
        return NONE;
    }

    public R getResult() {
        return this.result;
    }

    public Throwable getException() {
        return this.exception;
    }

    public long getDelay() {
        return this.delayNanos;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public boolean isNonResult() {
        return this.nonResult;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public ExecutionResult<R> withNonResult() {
        return this.success && this.result == null && this.nonResult ? this : new ExecutionResult<Object>(null, null, true, this.delayNanos, true, true, this.successAll);
    }

    public ExecutionResult<R> withResult(R r2) {
        boolean bl = this.result == null && r2 == null && this.exception == null;
        boolean bl2 = this.result != null && this.result.equals(r2);
        return this.success && (bl || bl2) ? this : new ExecutionResult<R>(r2, null, this.nonResult, this.delayNanos, true, true, this.successAll);
    }

    public ExecutionResult<R> withNotComplete() {
        return !this.complete ? this : new ExecutionResult<R>(this.result, this.exception, this.nonResult, this.delayNanos, false, this.success, this.successAll);
    }

    public ExecutionResult<R> withException() {
        return !this.success ? this : new ExecutionResult<R>(this.result, this.exception, this.nonResult, this.delayNanos, this.complete, false, false);
    }

    public ExecutionResult<R> withSuccess() {
        return this.complete && this.success ? this : new ExecutionResult<R>(this.result, this.exception, this.nonResult, this.delayNanos, true, true, this.successAll);
    }

    public ExecutionResult<R> withDelay(long l2) {
        return this.delayNanos == l2 ? this : new ExecutionResult<R>(this.result, this.exception, this.nonResult, l2, this.complete, this.success, this.successAll);
    }

    public ExecutionResult<R> with(long l2, boolean bl, boolean bl2) {
        return this.delayNanos == l2 && this.complete == bl && this.success == bl2 ? this : new ExecutionResult<R>(this.result, this.exception, this.nonResult, l2, bl, bl2, this.successAll == null ? bl2 : bl2 && this.successAll != false);
    }

    public boolean getSuccessAll() {
        return this.successAll != null && this.successAll != false;
    }

    public String toString() {
        return "[result=" + this.result + ", exception=" + this.exception + ", nonResult=" + this.nonResult + ", delayNanos=" + this.delayNanos + ", complete=" + this.complete + ", success=" + this.success + ", successAll=" + this.successAll + ']';
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ExecutionResult executionResult = (ExecutionResult)object;
        return Objects.equals(this.result, executionResult.result) && Objects.equals(this.exception, executionResult.exception);
    }

    public int hashCode() {
        return Objects.hash(this.result, this.exception);
    }
}

