/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.micrometer.core.aop;

import com.contrastsecurity.thirdparty.io.micrometer.core.annotation.Incubating;
import com.contrastsecurity.thirdparty.io.micrometer.core.annotation.Timed;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.LongTaskTimer;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.MeterRegistry;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Metrics;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Tag;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Tags;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Timer;
import com.contrastsecurity.thirdparty.io.micrometer.core.lang.NonNullApi;
import java.lang.reflect.Method;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.function.Predicate;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;

@Aspect
@NonNullApi
@Incubating(since="1.0.0")
public class TimedAspect {
    private static final Predicate<ProceedingJoinPoint> DONT_SKIP_ANYTHING = proceedingJoinPoint -> false;
    public static final String DEFAULT_METRIC_NAME = "method.timed";
    public static final String DEFAULT_EXCEPTION_TAG_VALUE = "none";
    public static final String EXCEPTION_TAG = "exception";
    private final MeterRegistry registry;
    private final Function<ProceedingJoinPoint, Iterable<Tag>> tagsBasedOnJoinPoint;
    private final Predicate<ProceedingJoinPoint> shouldSkip;

    public TimedAspect() {
        this(Metrics.globalRegistry);
    }

    public TimedAspect(MeterRegistry meterRegistry) {
        this(meterRegistry, DONT_SKIP_ANYTHING);
    }

    public TimedAspect(MeterRegistry meterRegistry, Function<ProceedingJoinPoint, Iterable<Tag>> function) {
        this(meterRegistry, function, DONT_SKIP_ANYTHING);
    }

    public TimedAspect(MeterRegistry meterRegistry, Predicate<ProceedingJoinPoint> predicate) {
        this(meterRegistry, proceedingJoinPoint -> Tags.of("class", proceedingJoinPoint.getStaticPart().getSignature().getDeclaringTypeName(), "method", proceedingJoinPoint.getStaticPart().getSignature().getName()), predicate);
    }

    public TimedAspect(MeterRegistry meterRegistry, Function<ProceedingJoinPoint, Iterable<Tag>> function, Predicate<ProceedingJoinPoint> predicate) {
        this.registry = meterRegistry;
        this.tagsBasedOnJoinPoint = function;
        this.shouldSkip = predicate;
    }

    @Around(value="execution (@io.micrometer.core.annotation.Timed * *.*(..))")
    public Object timedMethod(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        if (this.shouldSkip.test(proceedingJoinPoint)) {
            return proceedingJoinPoint.proceed();
        }
        Method method = ((MethodSignature)proceedingJoinPoint.getSignature()).getMethod();
        Timed timed = method.getAnnotation(Timed.class);
        if (timed == null) {
            method = proceedingJoinPoint.getTarget().getClass().getMethod(method.getName(), method.getParameterTypes());
            timed = method.getAnnotation(Timed.class);
        }
        String string = timed.value().isEmpty() ? DEFAULT_METRIC_NAME : timed.value();
        boolean bl = CompletionStage.class.isAssignableFrom(method.getReturnType());
        if (!timed.longTask()) {
            return this.processWithTimer(proceedingJoinPoint, timed, string, bl);
        }
        return this.processWithLongTaskTimer(proceedingJoinPoint, timed, string, bl);
    }

    private Object processWithTimer(ProceedingJoinPoint proceedingJoinPoint, Timed timed, String string, boolean bl) throws Throwable {
        Timer.Sample sample = Timer.start(this.registry);
        if (bl) {
            try {
                return ((CompletionStage)proceedingJoinPoint.proceed()).whenComplete((object, throwable) -> this.record(proceedingJoinPoint, timed, string, sample, this.getExceptionTag((Throwable)throwable)));
            }
            catch (Exception exception) {
                this.record(proceedingJoinPoint, timed, string, sample, exception.getClass().getSimpleName());
                throw exception;
            }
        }
        String string2 = DEFAULT_EXCEPTION_TAG_VALUE;
        try {
            Object object2 = proceedingJoinPoint.proceed();
            return object2;
        }
        catch (Exception exception) {
            string2 = exception.getClass().getSimpleName();
            throw exception;
        }
        finally {
            this.record(proceedingJoinPoint, timed, string, sample, string2);
        }
    }

    private void record(ProceedingJoinPoint proceedingJoinPoint, Timed timed, String string, Timer.Sample sample, String string2) {
        try {
            sample.stop(((Timer.Builder)Timer.builder(string).description(timed.description().isEmpty() ? null : timed.description()).tags(timed.extraTags()).tags(EXCEPTION_TAG, string2).tags((Iterable)this.tagsBasedOnJoinPoint.apply(proceedingJoinPoint))).publishPercentileHistogram(timed.histogram()).publishPercentiles(timed.percentiles().length == 0 ? null : timed.percentiles()).register(this.registry));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String getExceptionTag(Throwable throwable) {
        if (throwable == null) {
            return DEFAULT_EXCEPTION_TAG_VALUE;
        }
        if (throwable.getCause() == null) {
            return throwable.getClass().getSimpleName();
        }
        return throwable.getCause().getClass().getSimpleName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object processWithLongTaskTimer(ProceedingJoinPoint proceedingJoinPoint, Timed timed, String string, boolean bl) throws Throwable {
        Optional<LongTaskTimer.Sample> optional = this.buildLongTaskTimer(proceedingJoinPoint, timed, string).map(LongTaskTimer::start);
        if (bl) {
            try {
                return ((CompletionStage)proceedingJoinPoint.proceed()).whenComplete((object, throwable) -> optional.ifPresent(this::stopTimer));
            }
            catch (Exception exception) {
                optional.ifPresent(this::stopTimer);
                throw exception;
            }
        }
        try {
            Object object2 = proceedingJoinPoint.proceed();
            return object2;
        }
        finally {
            optional.ifPresent(this::stopTimer);
        }
    }

    private void stopTimer(LongTaskTimer.Sample sample) {
        try {
            sample.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Optional<LongTaskTimer> buildLongTaskTimer(ProceedingJoinPoint proceedingJoinPoint, Timed timed, String string) {
        try {
            return Optional.of(LongTaskTimer.builder(string).description(timed.description().isEmpty() ? null : timed.description()).tags(timed.extraTags()).tags(this.tagsBasedOnJoinPoint.apply(proceedingJoinPoint)).register(this.registry));
        }
        catch (Exception exception) {
            return Optional.empty();
        }
    }
}

