/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.micrometer.core.instrument;

import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.AbstractMeter;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Clock;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.DistributionSummary;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Meter;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.distribution.Histogram;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.distribution.HistogramSnapshot;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.distribution.NoopHistogram;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.distribution.TimeWindowFixedBoundaryHistogram;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.distribution.TimeWindowPercentileHistogram;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.util.MeterEquivalence;
import com.contrastsecurity.thirdparty.io.micrometer.core.lang.Nullable;

public abstract class AbstractDistributionSummary
extends AbstractMeter
implements DistributionSummary {
    protected final Histogram histogram;
    private final double scale;

    protected AbstractDistributionSummary(Meter.Id id, Clock clock, DistributionStatisticConfig distributionStatisticConfig, double d2, boolean bl) {
        super(id);
        this.scale = d2;
        this.histogram = distributionStatisticConfig.isPublishingPercentiles() ? new TimeWindowPercentileHistogram(clock, distributionStatisticConfig, bl) : (distributionStatisticConfig.isPublishingHistogram() ? new TimeWindowFixedBoundaryHistogram(clock, distributionStatisticConfig, bl) : NoopHistogram.INSTANCE);
    }

    @Override
    public final void record(double d2) {
        if (d2 >= 0.0) {
            double d3 = this.scale * d2;
            this.histogram.recordDouble(d3);
            this.recordNonNegative(d3);
        }
    }

    protected abstract void recordNonNegative(double var1);

    @Override
    public HistogramSnapshot takeSnapshot() {
        return this.histogram.takeSnapshot(this.count(), this.totalAmount(), this.max());
    }

    public boolean equals(@Nullable Object object) {
        return MeterEquivalence.equals(this, object);
    }

    public int hashCode() {
        return MeterEquivalence.hashCode(this);
    }
}

