/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.micrometer.core.instrument;

import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.AbstractMeter;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Clock;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Meter;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Timer;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.distribution.Histogram;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.distribution.HistogramSnapshot;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.distribution.NoopHistogram;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.distribution.TimeWindowFixedBoundaryHistogram;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.distribution.TimeWindowPercentileHistogram;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.distribution.pause.ClockDriftPauseDetector;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.distribution.pause.PauseDetector;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.util.MeterEquivalence;
import com.contrastsecurity.thirdparty.io.micrometer.core.lang.Nullable;
import com.contrastsecurity.thirdparty.org.LatencyUtils.IntervalEstimator;
import com.contrastsecurity.thirdparty.org.LatencyUtils.SimplePauseDetector;
import com.contrastsecurity.thirdparty.org.LatencyUtils.TimeCappedMovingAverageIntervalEstimator;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public abstract class AbstractTimer
extends AbstractMeter
implements Timer {
    private static Map<PauseDetector, com.contrastsecurity.thirdparty.org.LatencyUtils.PauseDetector> pauseDetectorCache = new ConcurrentHashMap<PauseDetector, com.contrastsecurity.thirdparty.org.LatencyUtils.PauseDetector>();
    protected final Clock clock;
    protected final Histogram histogram;
    private final TimeUnit baseTimeUnit;
    @Nullable
    private IntervalEstimator intervalEstimator = null;
    @Nullable
    private com.contrastsecurity.thirdparty.org.LatencyUtils.PauseDetector pauseDetector;

    @Deprecated
    protected AbstractTimer(Meter.Id id, Clock clock, DistributionStatisticConfig distributionStatisticConfig, PauseDetector pauseDetector, TimeUnit timeUnit) {
        this(id, clock, distributionStatisticConfig, pauseDetector, timeUnit, false);
    }

    protected AbstractTimer(Meter.Id id, Clock clock, DistributionStatisticConfig distributionStatisticConfig, PauseDetector pauseDetector, TimeUnit timeUnit, boolean bl) {
        super(id);
        this.clock = clock;
        this.baseTimeUnit = timeUnit;
        this.initPauseDetector(pauseDetector);
        this.histogram = distributionStatisticConfig.isPublishingPercentiles() ? new TimeWindowPercentileHistogram(clock, distributionStatisticConfig, bl) : (distributionStatisticConfig.isPublishingHistogram() ? new TimeWindowFixedBoundaryHistogram(clock, distributionStatisticConfig, bl) : NoopHistogram.INSTANCE);
    }

    private void initPauseDetector(PauseDetector pauseDetector2) {
        this.pauseDetector = pauseDetectorCache.computeIfAbsent(pauseDetector2, pauseDetector -> {
            if (pauseDetector instanceof ClockDriftPauseDetector) {
                ClockDriftPauseDetector clockDriftPauseDetector = (ClockDriftPauseDetector)pauseDetector;
                return new SimplePauseDetector(clockDriftPauseDetector.getSleepInterval().toNanos(), clockDriftPauseDetector.getPauseThreshold().toNanos(), 1, false);
            }
            return null;
        });
        if (this.pauseDetector instanceof SimplePauseDetector) {
            this.intervalEstimator = new TimeCappedMovingAverageIntervalEstimator(128, 10000000000L, this.pauseDetector);
            this.pauseDetector.addListener((l2, l3) -> {
                long l4;
                long l5;
                if (this.intervalEstimator != null && (l5 = l2 - (l4 = this.intervalEstimator.getEstimatedInterval(l3))) >= l4) {
                    this.recordValueWithExpectedInterval(l5, l4);
                }
            });
        }
    }

    private void recordValueWithExpectedInterval(long l2, long l3) {
        this.record(l2, TimeUnit.NANOSECONDS);
        if (l3 <= 0L) {
            return;
        }
        for (long i2 = l2 - l3; i2 >= l3; i2 -= l3) {
            this.record(i2, TimeUnit.NANOSECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T recordCallable(Callable<T> callable) throws Exception {
        long l2 = this.clock.monotonicTime();
        try {
            T t2 = callable.call();
            return t2;
        }
        finally {
            long l3 = this.clock.monotonicTime();
            this.record(l3 - l2, TimeUnit.NANOSECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T record(Supplier<T> supplier) {
        long l2 = this.clock.monotonicTime();
        try {
            T t2 = supplier.get();
            return t2;
        }
        finally {
            long l3 = this.clock.monotonicTime();
            this.record(l3 - l2, TimeUnit.NANOSECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void record(Runnable runnable) {
        long l2 = this.clock.monotonicTime();
        try {
            runnable.run();
        }
        finally {
            long l3 = this.clock.monotonicTime();
            this.record(l3 - l2, TimeUnit.NANOSECONDS);
        }
    }

    @Override
    public final void record(long l2, TimeUnit timeUnit) {
        if (l2 >= 0L) {
            this.histogram.recordLong(TimeUnit.NANOSECONDS.convert(l2, timeUnit));
            this.recordNonNegative(l2, timeUnit);
            if (this.intervalEstimator != null) {
                this.intervalEstimator.recordInterval(this.clock.monotonicTime());
            }
        }
    }

    protected abstract void recordNonNegative(long var1, TimeUnit var3);

    @Override
    public HistogramSnapshot takeSnapshot() {
        return this.histogram.takeSnapshot(this.count(), this.totalTime(TimeUnit.NANOSECONDS), this.max(TimeUnit.NANOSECONDS));
    }

    @Override
    public TimeUnit baseTimeUnit() {
        return this.baseTimeUnit;
    }

    public boolean equals(@Nullable Object object) {
        return MeterEquivalence.equals(this, object);
    }

    public int hashCode() {
        return MeterEquivalence.hashCode(this);
    }

    @Override
    public void close() {
        this.histogram.close();
        if (this.pauseDetector != null) {
            this.pauseDetector.shutdown();
        }
    }
}

