/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.micrometer.core.instrument;

import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Tag;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Tags;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.distribution.pause.PauseDetector;
import com.contrastsecurity.thirdparty.io.micrometer.core.lang.Nullable;
import java.time.Duration;
import java.util.Arrays;

public abstract class AbstractTimerBuilder<B extends AbstractTimerBuilder<B>> {
    protected final String name;
    protected Tags tags = Tags.empty();
    protected final DistributionStatisticConfig.Builder distributionConfigBuilder;
    @Nullable
    protected String description;
    @Nullable
    protected PauseDetector pauseDetector;

    protected AbstractTimerBuilder(String string) {
        this.name = string;
        this.distributionConfigBuilder = new DistributionStatisticConfig.Builder();
        this.minimumExpectedValue(Duration.ofMillis(1L));
        this.maximumExpectedValue(Duration.ofSeconds(30L));
    }

    public B tags(String ... stringArray) {
        return this.tags(Tags.of(stringArray));
    }

    public B tags(Iterable<Tag> iterable) {
        this.tags = this.tags.and(iterable);
        return (B)this;
    }

    public B tag(String string, String string2) {
        this.tags = this.tags.and(string, string2);
        return (B)this;
    }

    public B publishPercentiles(double ... dArray) {
        this.distributionConfigBuilder.percentiles(dArray);
        return (B)this;
    }

    public B percentilePrecision(@Nullable Integer n2) {
        this.distributionConfigBuilder.percentilePrecision(n2);
        return (B)this;
    }

    public B publishPercentileHistogram() {
        return this.publishPercentileHistogram(true);
    }

    public B publishPercentileHistogram(@Nullable Boolean bl) {
        this.distributionConfigBuilder.percentilesHistogram(bl);
        return (B)this;
    }

    @Deprecated
    public B sla(Duration ... durationArray) {
        return this.serviceLevelObjectives(durationArray);
    }

    public B serviceLevelObjectives(Duration ... durationArray) {
        if (durationArray != null) {
            this.distributionConfigBuilder.serviceLevelObjectives(Arrays.stream(durationArray).mapToDouble(Duration::toNanos).toArray());
        }
        return (B)this;
    }

    public B minimumExpectedValue(@Nullable Duration duration) {
        if (duration != null) {
            this.distributionConfigBuilder.minimumExpectedValue(Double.valueOf(duration.toNanos()));
        }
        return (B)this;
    }

    public B maximumExpectedValue(@Nullable Duration duration) {
        if (duration != null) {
            this.distributionConfigBuilder.maximumExpectedValue(Double.valueOf(duration.toNanos()));
        }
        return (B)this;
    }

    public B distributionStatisticExpiry(@Nullable Duration duration) {
        this.distributionConfigBuilder.expiry(duration);
        return (B)this;
    }

    public B distributionStatisticBufferLength(@Nullable Integer n2) {
        this.distributionConfigBuilder.bufferLength(n2);
        return (B)this;
    }

    public B pauseDetector(@Nullable PauseDetector pauseDetector) {
        this.pauseDetector = pauseDetector;
        return (B)this;
    }

    public B description(@Nullable String string) {
        this.description = string;
        return (B)this;
    }
}

