/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.micrometer.core.instrument;

import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Measurement;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Meter;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.MeterRegistry;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Statistic;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Tag;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Tags;
import com.contrastsecurity.thirdparty.io.micrometer.core.lang.Nullable;
import java.util.Collections;

public interface Counter
extends Meter {
    public static Builder builder(String string) {
        return new Builder(string);
    }

    default public void increment() {
        this.increment(1.0);
    }

    public void increment(double var1);

    public double count();

    @Override
    default public Iterable<Measurement> measure() {
        return Collections.singletonList(new Measurement(this::count, Statistic.COUNT));
    }

    public static class Builder {
        private final String name;
        private Tags tags = Tags.empty();
        @Nullable
        private String description;
        @Nullable
        private String baseUnit;

        private Builder(String string) {
            this.name = string;
        }

        public Builder tags(String ... stringArray) {
            return this.tags(Tags.of(stringArray));
        }

        public Builder tags(Iterable<Tag> iterable) {
            this.tags = this.tags.and(iterable);
            return this;
        }

        public Builder tag(String string, String string2) {
            this.tags = this.tags.and(string, string2);
            return this;
        }

        public Builder description(@Nullable String string) {
            this.description = string;
            return this;
        }

        public Builder baseUnit(@Nullable String string) {
            this.baseUnit = string;
            return this;
        }

        public Counter register(MeterRegistry meterRegistry) {
            return meterRegistry.counter(new Meter.Id(this.name, this.tags, this.baseUnit, this.description, Meter.Type.COUNTER));
        }
    }
}

