/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.micrometer.core.instrument;

import com.contrastsecurity.thirdparty.io.micrometer.core.annotation.Timed;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Measurement;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Meter;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.MeterRegistry;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Statistic;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Tag;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Tags;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.distribution.HistogramSupport;
import com.contrastsecurity.thirdparty.io.micrometer.core.lang.Nullable;
import java.time.Duration;
import java.util.Arrays;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;

public interface LongTaskTimer
extends Meter,
HistogramSupport {
    public static Builder builder(String string) {
        return new Builder(string);
    }

    public static Builder builder(Timed timed) {
        if (!timed.longTask()) {
            throw new IllegalArgumentException("Cannot build a long task timer from a @Timed annotation that is not marked as a long task");
        }
        if (timed.value().isEmpty()) {
            throw new IllegalArgumentException("Long tasks instrumented with @Timed require the value attribute to be non-empty");
        }
        return new Builder(timed.value()).tags(timed.extraTags()).publishPercentileHistogram(timed.histogram()).description(timed.description().isEmpty() ? null : timed.description());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public <T> T recordCallable(Callable<T> callable) throws Exception {
        Sample sample = this.start();
        try {
            T t2 = callable.call();
            return t2;
        }
        finally {
            sample.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public <T> T record(Supplier<T> supplier) {
        Sample sample = this.start();
        try {
            T t2 = supplier.get();
            return t2;
        }
        finally {
            sample.stop();
        }
    }

    default public void record(Consumer<Sample> consumer) {
        Sample sample = this.start();
        try {
            consumer.accept(sample);
        }
        finally {
            sample.stop();
        }
    }

    default public void record(Runnable runnable) {
        Sample sample = this.start();
        try {
            runnable.run();
        }
        finally {
            sample.stop();
        }
    }

    public Sample start();

    public double duration(TimeUnit var1);

    public int activeTasks();

    default public double mean(TimeUnit timeUnit) {
        int n2 = this.activeTasks();
        return n2 == 0 ? 0.0 : this.duration(timeUnit) / (double)n2;
    }

    public double max(TimeUnit var1);

    public TimeUnit baseTimeUnit();

    @Deprecated
    default public long stop(long l2) {
        return -1L;
    }

    @Deprecated
    default public double duration(long l2, TimeUnit timeUnit) {
        return -1.0;
    }

    @Override
    default public Iterable<Measurement> measure() {
        return Arrays.asList(new Measurement(() -> this.activeTasks(), Statistic.ACTIVE_TASKS), new Measurement(() -> this.duration(this.baseTimeUnit()), Statistic.DURATION));
    }

    public static class Builder {
        private final String name;
        private Tags tags = Tags.empty();
        private final DistributionStatisticConfig.Builder distributionConfigBuilder = new DistributionStatisticConfig.Builder();
        @Nullable
        private String description;

        private Builder(String string) {
            this.name = string;
            this.minimumExpectedValue(Duration.ofMinutes(2L));
            this.maximumExpectedValue(Duration.ofHours(2L));
        }

        public Builder tags(String ... stringArray) {
            return this.tags(Tags.of(stringArray));
        }

        public Builder tags(Iterable<Tag> iterable) {
            this.tags = this.tags.and(iterable);
            return this;
        }

        public Builder tag(String string, String string2) {
            this.tags = this.tags.and(string, string2);
            return this;
        }

        public Builder description(@Nullable String string) {
            this.description = string;
            return this;
        }

        public Builder serviceLevelObjectives(Duration ... durationArray) {
            if (durationArray != null) {
                this.distributionConfigBuilder.serviceLevelObjectives(Arrays.stream(durationArray).mapToDouble(Duration::toNanos).toArray());
            }
            return this;
        }

        public Builder minimumExpectedValue(@Nullable Duration duration) {
            if (duration != null) {
                this.distributionConfigBuilder.minimumExpectedValue(Double.valueOf(duration.toNanos()));
            }
            return this;
        }

        public Builder maximumExpectedValue(@Nullable Duration duration) {
            if (duration != null) {
                this.distributionConfigBuilder.maximumExpectedValue(Double.valueOf(duration.toNanos()));
            }
            return this;
        }

        public Builder distributionStatisticExpiry(@Nullable Duration duration) {
            this.distributionConfigBuilder.expiry(duration);
            return this;
        }

        public Builder distributionStatisticBufferLength(@Nullable Integer n2) {
            this.distributionConfigBuilder.bufferLength(n2);
            return this;
        }

        public Builder publishPercentiles(double ... dArray) {
            this.distributionConfigBuilder.percentiles(dArray);
            return this;
        }

        public Builder percentilePrecision(@Nullable Integer n2) {
            this.distributionConfigBuilder.percentilePrecision(n2);
            return this;
        }

        public Builder publishPercentileHistogram() {
            return this.publishPercentileHistogram(true);
        }

        public Builder publishPercentileHistogram(@Nullable Boolean bl) {
            this.distributionConfigBuilder.percentilesHistogram(bl);
            return this;
        }

        public LongTaskTimer register(MeterRegistry meterRegistry) {
            return meterRegistry.more().longTaskTimer(new Meter.Id(this.name, this.tags, null, this.description, Meter.Type.LONG_TASK_TIMER), this.distributionConfigBuilder.build());
        }
    }

    public static abstract class Sample {
        public abstract long stop();

        public abstract double duration(TimeUnit var1);
    }
}

