/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.micrometer.core.instrument;

import com.contrastsecurity.thirdparty.io.micrometer.core.annotation.Incubating;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Meter;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.MeterRegistry;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.StrongReferenceGaugeFunction;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Tag;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Tags;
import com.contrastsecurity.thirdparty.io.micrometer.core.lang.Nullable;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

@Incubating(since="1.1.0")
public class MultiGauge {
    private final MeterRegistry registry;
    private final Meter.Id commonId;
    private final AtomicReference<Set<Meter.Id>> registeredRows = new AtomicReference(Collections.emptySet());

    private MultiGauge(MeterRegistry meterRegistry, Meter.Id id) {
        this.registry = meterRegistry;
        this.commonId = id;
    }

    public static Builder builder(String string) {
        return new Builder(string);
    }

    public void register(Iterable<Row<?>> iterable) {
        this.register(iterable, false);
    }

    public void register(Iterable<Row<?>> iterable, boolean bl) {
        this.registeredRows.getAndUpdate(set -> {
            Stream<Meter.Id> stream = StreamSupport.stream(iterable.spliterator(), false).map(row -> {
                Row row2 = row;
                Meter.Id id = this.commonId.withTags(((Row)row).uniqueTags);
                boolean bl2 = set.contains(id);
                if (bl && bl2) {
                    this.registry.removeByPreFilterId(id);
                }
                if (bl || !bl2) {
                    this.registry.gauge(id, ((Row)row).obj, new StrongReferenceGaugeFunction<Object>(row2.obj, row2.valueFunction));
                }
                return id;
            });
            Set set2 = stream.collect(Collectors.toSet());
            for (Meter.Id id : set) {
                if (set2.contains(id)) continue;
                this.registry.removeByPreFilterId(id);
            }
            return set2;
        });
    }

    public static class Builder {
        private final String name;
        private Tags tags = Tags.empty();
        @Nullable
        private String description;
        @Nullable
        private String baseUnit;

        private Builder(String string) {
            this.name = string;
        }

        public Builder tags(String ... stringArray) {
            return this.tags(Tags.of(stringArray));
        }

        public Builder tags(Iterable<Tag> iterable) {
            this.tags = this.tags.and(iterable);
            return this;
        }

        public Builder tag(String string, String string2) {
            this.tags = this.tags.and(string, string2);
            return this;
        }

        public Builder description(@Nullable String string) {
            this.description = string;
            return this;
        }

        public Builder baseUnit(@Nullable String string) {
            this.baseUnit = string;
            return this;
        }

        public MultiGauge register(MeterRegistry meterRegistry) {
            return new MultiGauge(meterRegistry, new Meter.Id(this.name, this.tags, this.baseUnit, this.description, Meter.Type.GAUGE, null));
        }
    }

    public static class Row<T> {
        private final Tags uniqueTags;
        private final T obj;
        private final ToDoubleFunction<T> valueFunction;

        private Row(Tags tags, T t2, ToDoubleFunction<T> toDoubleFunction) {
            this.uniqueTags = tags;
            this.obj = t2;
            this.valueFunction = toDoubleFunction;
        }

        public static <T> Row<T> of(Tags tags, T t2, ToDoubleFunction<T> toDoubleFunction) {
            return new Row<T>(tags, t2, toDoubleFunction);
        }

        public static Row<Number> of(Tags tags, Number number) {
            return new Row<Number>(tags, number, Number::doubleValue);
        }

        public static Row<Supplier<Number>> of(Tags tags, Supplier<Number> supplier) {
            return new Row<Supplier<Number>>(tags, supplier, supplier2 -> {
                Number number = (Number)supplier.get();
                return number == null ? Double.NaN : number.doubleValue();
            });
        }
    }
}

