/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.micrometer.core.instrument;

import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Tag;
import com.contrastsecurity.thirdparty.io.micrometer.core.lang.Nullable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public final class Tags
implements Iterable<Tag> {
    private static final Tags EMPTY = new Tags(new Tag[0]);
    private final Tag[] tags;
    private int last;

    private Tags(Tag[] tagArray) {
        this.tags = tagArray;
        Arrays.sort(this.tags);
        this.dedup();
    }

    private void dedup() {
        int n2 = this.tags.length;
        if (n2 == 0 || n2 == 1) {
            this.last = n2;
            return;
        }
        int n3 = 0;
        for (int i2 = 0; i2 < n2 - 1; ++i2) {
            if (this.tags[i2].getKey().equals(this.tags[i2 + 1].getKey())) continue;
            this.tags[n3++] = this.tags[i2];
        }
        this.tags[n3++] = this.tags[n2 - 1];
        this.last = n3;
    }

    public Tags and(String string, String string2) {
        return this.and(Tag.of(string, string2));
    }

    public Tags and(String ... stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return this;
        }
        return this.and(Tags.of(stringArray));
    }

    public Tags and(Tag ... tagArray) {
        if (tagArray == null || tagArray.length == 0) {
            return this;
        }
        Tag[] tagArray2 = new Tag[this.last + tagArray.length];
        System.arraycopy(this.tags, 0, tagArray2, 0, this.last);
        System.arraycopy(tagArray, 0, tagArray2, this.last, tagArray.length);
        return new Tags(tagArray2);
    }

    public Tags and(@Nullable Iterable<? extends Tag> iterable) {
        if (iterable == null || !iterable.iterator().hasNext()) {
            return this;
        }
        if (this.tags.length == 0) {
            return Tags.of(iterable);
        }
        return this.and(Tags.of(iterable).tags);
    }

    @Override
    public Iterator<Tag> iterator() {
        return new ArrayIterator();
    }

    public Stream<Tag> stream() {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.iterator(), 277), false);
    }

    public int hashCode() {
        int n2 = 1;
        for (int i2 = 0; i2 < this.last; ++i2) {
            n2 = 31 * n2 + this.tags[i2].hashCode();
        }
        return n2;
    }

    public boolean equals(@Nullable Object object) {
        return this == object || object != null && this.getClass() == object.getClass() && this.tagsEqual((Tags)object);
    }

    private boolean tagsEqual(Tags tags) {
        if (this.tags == tags.tags) {
            return true;
        }
        if (this.last != tags.last) {
            return false;
        }
        for (int i2 = 0; i2 < this.last; ++i2) {
            if (this.tags[i2].equals(tags.tags[i2])) continue;
            return false;
        }
        return true;
    }

    public static Tags concat(@Nullable Iterable<? extends Tag> iterable, @Nullable Iterable<Tag> iterable2) {
        return Tags.of(iterable).and(iterable2);
    }

    public static Tags concat(@Nullable Iterable<? extends Tag> iterable, String ... stringArray) {
        return Tags.of(iterable).and(stringArray);
    }

    public static Tags of(@Nullable Iterable<? extends Tag> iterable) {
        if (iterable == null || !iterable.iterator().hasNext()) {
            return Tags.empty();
        }
        if (iterable instanceof Tags) {
            return (Tags)iterable;
        }
        if (iterable instanceof Collection) {
            Collection collection = (Collection)iterable;
            return new Tags(collection.toArray(new Tag[0]));
        }
        return new Tags((Tag[])StreamSupport.stream(iterable.spliterator(), false).toArray(Tag[]::new));
    }

    public static Tags of(String string, String string2) {
        return new Tags(new Tag[]{Tag.of(string, string2)});
    }

    public static Tags of(String ... stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return Tags.empty();
        }
        if (stringArray.length % 2 == 1) {
            throw new IllegalArgumentException("size must be even, it is a set of key=value pairs");
        }
        Tag[] tagArray = new Tag[stringArray.length / 2];
        for (int i2 = 0; i2 < stringArray.length; i2 += 2) {
            tagArray[i2 / 2] = Tag.of(stringArray[i2], stringArray[i2 + 1]);
        }
        return new Tags(tagArray);
    }

    public static Tags of(Tag ... tagArray) {
        return Tags.empty().and(tagArray);
    }

    public static Tags empty() {
        return EMPTY;
    }

    public String toString() {
        return this.stream().map(Object::toString).collect(Collectors.joining(",", "[", "]"));
    }

    private class ArrayIterator
    implements Iterator<Tag> {
        private int currentIndex = 0;

        private ArrayIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.currentIndex < Tags.this.last;
        }

        @Override
        public Tag next() {
            return Tags.this.tags[this.currentIndex++];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("cannot remove items from tags");
        }
    }
}

