/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.micrometer.core.instrument;

import com.contrastsecurity.thirdparty.io.micrometer.core.annotation.Incubating;
import com.contrastsecurity.thirdparty.io.micrometer.core.annotation.Timed;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.AbstractTimerBuilder;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Clock;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Measurement;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Meter;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.MeterRegistry;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Statistic;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Tag;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.distribution.CountAtBucket;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.distribution.HistogramSupport;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.distribution.ValueAtPercentile;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.distribution.pause.PauseDetector;
import com.contrastsecurity.thirdparty.io.micrometer.core.lang.Nullable;
import java.time.Duration;
import java.util.Arrays;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public interface Timer
extends Meter,
HistogramSupport {
    public static Sample start() {
        return Timer.start(Clock.SYSTEM);
    }

    public static Sample start(MeterRegistry meterRegistry) {
        return Timer.start(meterRegistry.config().clock());
    }

    public static Sample start(Clock clock) {
        return new Sample(clock);
    }

    public static Builder builder(String string) {
        return new Builder(string);
    }

    @Incubating(since="1.6.0")
    public static ResourceSample resource(MeterRegistry meterRegistry, String string) {
        return new ResourceSample(meterRegistry, string);
    }

    public static Builder builder(Timed timed, String string) {
        if (timed.longTask() && timed.value().isEmpty()) {
            throw new IllegalArgumentException("Long tasks instrumented with @Timed require the value attribute to be non-empty");
        }
        return new Builder(timed.value().isEmpty() ? string : timed.value()).tags(timed.extraTags()).description(timed.description().isEmpty() ? null : timed.description()).publishPercentileHistogram(timed.histogram()).publishPercentiles(timed.percentiles().length > 0 ? timed.percentiles() : null);
    }

    public void record(long var1, TimeUnit var3);

    default public void record(Duration duration) {
        this.record(duration.toNanos(), TimeUnit.NANOSECONDS);
    }

    @Nullable
    public <T> T record(Supplier<T> var1);

    @Nullable
    public <T> T recordCallable(Callable<T> var1) throws Exception;

    public void record(Runnable var1);

    default public Runnable wrap(Runnable runnable) {
        return () -> this.record(runnable);
    }

    default public <T> Callable<T> wrap(Callable<T> callable) {
        return () -> this.recordCallable(callable);
    }

    default public <T> Supplier<T> wrap(Supplier<T> supplier) {
        return () -> this.record(supplier);
    }

    public long count();

    public double totalTime(TimeUnit var1);

    default public double mean(TimeUnit timeUnit) {
        long l2 = this.count();
        return l2 == 0L ? 0.0 : this.totalTime(timeUnit) / (double)l2;
    }

    public double max(TimeUnit var1);

    @Override
    default public Iterable<Measurement> measure() {
        return Arrays.asList(new Measurement(() -> this.count(), Statistic.COUNT), new Measurement(() -> this.totalTime(this.baseTimeUnit()), Statistic.TOTAL_TIME), new Measurement(() -> this.max(this.baseTimeUnit()), Statistic.MAX));
    }

    @Deprecated
    default public double histogramCountAtValue(long l2) {
        for (CountAtBucket countAtBucket : this.takeSnapshot().histogramCounts()) {
            if ((long)countAtBucket.bucket(TimeUnit.NANOSECONDS) != l2) continue;
            return countAtBucket.count();
        }
        return Double.NaN;
    }

    @Deprecated
    default public double percentile(double d2, TimeUnit timeUnit) {
        for (ValueAtPercentile valueAtPercentile : this.takeSnapshot().percentileValues()) {
            if (valueAtPercentile.percentile() != d2) continue;
            return valueAtPercentile.value(timeUnit);
        }
        return Double.NaN;
    }

    public TimeUnit baseTimeUnit();

    public static class Sample {
        private final long startTime;
        private final Clock clock;

        Sample(Clock clock) {
            this.clock = clock;
            this.startTime = clock.monotonicTime();
        }

        public long stop(Timer timer) {
            long l2 = this.clock.monotonicTime() - this.startTime;
            timer.record(l2, TimeUnit.NANOSECONDS);
            return l2;
        }
    }

    public static class Builder
    extends AbstractTimerBuilder<Builder> {
        Builder(String string) {
            super(string);
        }

        @Override
        public Builder tags(String ... stringArray) {
            return (Builder)super.tags(stringArray);
        }

        @Override
        public Builder tags(Iterable<Tag> iterable) {
            return (Builder)super.tags(iterable);
        }

        @Override
        public Builder tag(String string, String string2) {
            return (Builder)super.tag(string, string2);
        }

        @Override
        public Builder publishPercentiles(double ... dArray) {
            return (Builder)super.publishPercentiles(dArray);
        }

        @Override
        public Builder percentilePrecision(Integer n2) {
            return (Builder)super.percentilePrecision(n2);
        }

        @Override
        public Builder publishPercentileHistogram() {
            return (Builder)super.publishPercentileHistogram();
        }

        @Override
        public Builder publishPercentileHistogram(Boolean bl) {
            return (Builder)super.publishPercentileHistogram(bl);
        }

        @Override
        public Builder sla(Duration ... durationArray) {
            return (Builder)super.sla(durationArray);
        }

        @Override
        public Builder serviceLevelObjectives(Duration ... durationArray) {
            return (Builder)super.serviceLevelObjectives(durationArray);
        }

        @Override
        public Builder minimumExpectedValue(Duration duration) {
            return (Builder)super.minimumExpectedValue(duration);
        }

        @Override
        public Builder maximumExpectedValue(Duration duration) {
            return (Builder)super.maximumExpectedValue(duration);
        }

        @Override
        public Builder distributionStatisticExpiry(Duration duration) {
            return (Builder)super.distributionStatisticExpiry(duration);
        }

        @Override
        public Builder distributionStatisticBufferLength(Integer n2) {
            return (Builder)super.distributionStatisticBufferLength(n2);
        }

        @Override
        public Builder pauseDetector(PauseDetector pauseDetector) {
            return (Builder)super.pauseDetector(pauseDetector);
        }

        @Override
        public Builder description(String string) {
            return (Builder)super.description(string);
        }

        public Timer register(MeterRegistry meterRegistry) {
            return meterRegistry.timer(new Meter.Id(this.name, this.tags, null, this.description, Meter.Type.TIMER), this.distributionConfigBuilder.build(), this.pauseDetector == null ? meterRegistry.config().pauseDetector() : this.pauseDetector);
        }
    }

    public static class ResourceSample
    extends AbstractTimerBuilder<ResourceSample>
    implements AutoCloseable {
        private final MeterRegistry registry;
        private final long startTime;

        ResourceSample(MeterRegistry meterRegistry, String string) {
            super(string);
            this.registry = meterRegistry;
            this.startTime = meterRegistry.config().clock().monotonicTime();
        }

        @Override
        public void close() {
            long l2 = this.registry.config().clock().monotonicTime() - this.startTime;
            this.registry.timer(new Meter.Id(this.name, this.tags, null, this.description, Meter.Type.TIMER), this.distributionConfigBuilder.build(), this.pauseDetector == null ? this.registry.config().pauseDetector() : this.pauseDetector).record(l2, TimeUnit.NANOSECONDS);
        }
    }
}

