/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.micrometer.core.instrument.binder.cache;

import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Counter;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.DistributionSummary;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Gauge;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.MeterRegistry;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Tag;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Tags;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Timer;
import com.contrastsecurity.thirdparty.io.micrometer.core.lang.NonNullApi;
import com.contrastsecurity.thirdparty.io.micrometer.core.lang.NonNullFields;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.RemovalCause;
import com.github.benmanes.caffeine.cache.stats.CacheStats;
import com.github.benmanes.caffeine.cache.stats.StatsCounter;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

@NonNullApi
@NonNullFields
public final class CaffeineStatsCounter
implements StatsCounter {
    private final MeterRegistry registry;
    private final Tags tags;
    private final Counter hitCount;
    private final Counter missCount;
    private final Timer loadSuccesses;
    private final Timer loadFailures;
    private final EnumMap<RemovalCause, DistributionSummary> evictionMetrics;

    public CaffeineStatsCounter(MeterRegistry meterRegistry, String string) {
        this(meterRegistry, string, Tags.empty());
    }

    public CaffeineStatsCounter(MeterRegistry meterRegistry, String string, Iterable<Tag> iterable) {
        Objects.requireNonNull(meterRegistry);
        Objects.requireNonNull(string);
        Objects.requireNonNull(iterable);
        this.registry = meterRegistry;
        this.tags = Tags.concat(iterable, "cache", string);
        this.hitCount = Counter.builder("cache.gets").tag("result", "hit").tags(this.tags).description("The number of times cache lookup methods have returned a cached value.").register(meterRegistry);
        this.missCount = Counter.builder("cache.gets").tag("result", "miss").tags(this.tags).description("The number of times cache lookup methods have returned an uncached (newly loaded) value.").register(meterRegistry);
        this.loadSuccesses = ((Timer.Builder)Timer.builder("cache.loads").tag("result", "success").tags((Iterable)this.tags)).description("Successful cache loads.").register(meterRegistry);
        this.loadFailures = ((Timer.Builder)Timer.builder("cache.loads").tag("result", "failure").tags((Iterable)this.tags)).description("Failed cache loads.").register(meterRegistry);
        this.evictionMetrics = new EnumMap(RemovalCause.class);
        Arrays.stream(RemovalCause.values()).forEach(removalCause -> this.evictionMetrics.put((RemovalCause)removalCause, DistributionSummary.builder("cache.evictions").tag("cause", removalCause.name()).tags(this.tags).description("Entries evicted from cache.").register(meterRegistry)));
    }

    public void registerSizeMetric(Cache<?, ?> cache) {
        Gauge.builder("cache.size", cache, Cache::estimatedSize).tags(this.tags).description("The approximate number of entries in this cache.").register(this.registry);
    }

    public void recordHits(int n2) {
        this.hitCount.increment(n2);
    }

    public void recordMisses(int n2) {
        this.missCount.increment(n2);
    }

    public void recordLoadSuccess(long l2) {
        this.loadSuccesses.record(l2, TimeUnit.NANOSECONDS);
    }

    public void recordLoadFailure(long l2) {
        this.loadFailures.record(l2, TimeUnit.NANOSECONDS);
    }

    public void recordEviction() {
    }

    public void recordEviction(int n2, RemovalCause removalCause) {
        this.evictionMetrics.get(removalCause).record(n2);
    }

    public CacheStats snapshot() {
        return CacheStats.of((long)((long)this.hitCount.count()), (long)((long)this.missCount.count()), (long)this.loadSuccesses.count(), (long)this.loadFailures.count(), (long)((long)this.loadSuccesses.totalTime(TimeUnit.NANOSECONDS) + (long)this.loadFailures.totalTime(TimeUnit.NANOSECONDS)), (long)this.evictionMetrics.values().stream().mapToLong(DistributionSummary::count).sum(), (long)((long)this.evictionMetrics.values().stream().mapToDouble(DistributionSummary::totalAmount).sum()));
    }

    public String toString() {
        return this.snapshot().toString();
    }
}

