/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.micrometer.core.instrument.binder.cache;

import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Gauge;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.MeterRegistry;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Tag;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Tags;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.binder.cache.CacheMeterBinder;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.config.InvalidConfigurationException;
import com.contrastsecurity.thirdparty.io.micrometer.core.lang.NonNullApi;
import com.contrastsecurity.thirdparty.io.micrometer.core.lang.NonNullFields;
import com.contrastsecurity.thirdparty.io.micrometer.core.lang.Nullable;
import java.util.ArrayList;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;

@NonNullApi
@NonNullFields
public class JCacheMetrics<K, V, C extends Cache<K, V>>
extends CacheMeterBinder<C> {
    @Nullable
    ObjectName objectName;

    public static <K, V, C extends Cache<K, V>> C monitor(MeterRegistry meterRegistry, C c2, String ... stringArray) {
        return JCacheMetrics.monitor(meterRegistry, c2, Tags.of(stringArray));
    }

    public static <K, V, C extends Cache<K, V>> C monitor(MeterRegistry meterRegistry, C c2, Iterable<Tag> iterable) {
        new JCacheMetrics<K, V, C>(c2, iterable).bindTo(meterRegistry);
        return c2;
    }

    public JCacheMetrics(C c2, Iterable<Tag> iterable) {
        super(c2, c2.getName(), iterable);
        try {
            CacheManager cacheManager = c2.getCacheManager();
            if (cacheManager != null) {
                String string = cacheManager.getURI().toString().replace(':', '.');
                this.objectName = new ObjectName("javax.cache:type=CacheStatistics,CacheManager=" + string + ",Cache=" + c2.getName());
            }
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            throw new InvalidConfigurationException("Cache name '" + c2.getName() + "' results in an invalid JMX name");
        }
    }

    @Override
    protected Long size() {
        return null;
    }

    @Override
    protected long hitCount() {
        return this.lookupStatistic("CacheHits");
    }

    @Override
    protected Long missCount() {
        return this.lookupStatistic("CacheMisses");
    }

    @Override
    protected Long evictionCount() {
        return this.lookupStatistic("CacheEvictions");
    }

    @Override
    protected long putCount() {
        return this.lookupStatistic("CachePuts");
    }

    @Override
    protected void bindImplementationSpecificMetrics(MeterRegistry meterRegistry) {
        if (this.objectName != null) {
            Gauge.builder("cache.removals", this.objectName, objectName -> this.lookupStatistic("CacheRemovals").longValue()).tags(this.getTagsWithCacheName()).description("Cache removals").register(meterRegistry);
        }
    }

    private Long lookupStatistic(String string) {
        if (this.objectName != null) {
            try {
                ArrayList<MBeanServer> arrayList = MBeanServerFactory.findMBeanServer(null);
                for (MBeanServer mBeanServer : arrayList) {
                    try {
                        return (Long)mBeanServer.getAttribute(this.objectName, string);
                    }
                    catch (AttributeNotFoundException | InstanceNotFoundException operationsException) {
                    }
                }
            }
            catch (MBeanException | ReflectionException jMException) {
                throw new IllegalStateException(jMException);
            }
        }
        return 0L;
    }
}

