/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.micrometer.core.instrument.binder.commonspool2;

import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.FunctionCounter;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Gauge;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Meter;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.MeterRegistry;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Tag;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Tags;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.TimeGauge;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.binder.MeterBinder;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.util.NamedThreadFactory;
import com.contrastsecurity.thirdparty.io.micrometer.core.lang.NonNull;
import com.contrastsecurity.thirdparty.io.micrometer.core.lang.Nullable;
import com.contrastsecurity.thirdparty.io.micrometer.core.util.internal.logging.InternalLogger;
import com.contrastsecurity.thirdparty.io.micrometer.core.util.internal.logging.InternalLoggerFactory;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.ToDoubleFunction;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MBeanServerDelegate;
import javax.management.MBeanServerFactory;
import javax.management.MBeanServerNotification;
import javax.management.MalformedObjectNameException;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public class CommonsObjectPool2Metrics
implements MeterBinder,
AutoCloseable {
    private static final InternalLogger log = InternalLoggerFactory.getInstance(CommonsObjectPool2Metrics.class);
    private static final String JMX_DOMAIN = "com.contrastsecurity.thirdparty.org.apache.commons.pool2";
    private static final String METRIC_NAME_PREFIX = "commons.pool2.";
    private static final String[] TYPES = new String[]{"GenericObjectPool", "GenericKeyedObjectPool"};
    private final ExecutorService executor = Executors.newSingleThreadExecutor(new NamedThreadFactory("commons-pool-metrics-updater"));
    private final MBeanServer mBeanServer;
    private final Iterable<Tag> tags;
    private final List<Runnable> notificationListenerCleanUpRunnables = new CopyOnWriteArrayList<Runnable>();

    public CommonsObjectPool2Metrics() {
        this(Collections.emptyList());
    }

    public CommonsObjectPool2Metrics(Iterable<Tag> iterable) {
        this(CommonsObjectPool2Metrics.getMBeanServer(), iterable);
    }

    public CommonsObjectPool2Metrics(MBeanServer mBeanServer, Iterable<Tag> iterable) {
        this.mBeanServer = mBeanServer;
        this.tags = iterable;
    }

    private static MBeanServer getMBeanServer() {
        ArrayList<MBeanServer> arrayList = MBeanServerFactory.findMBeanServer(null);
        if (!arrayList.isEmpty()) {
            return (MBeanServer)arrayList.get(0);
        }
        return ManagementFactory.getPlatformMBeanServer();
    }

    @Override
    public void bindTo(@NonNull MeterRegistry meterRegistry) {
        for (String string : TYPES) {
            this.registerMetricsEventually(string, (objectName, tags) -> {
                this.registerGaugeForObject(meterRegistry, (ObjectName)objectName, "NumIdle", "num.idle", (Tags)tags, "The number of instances currently idle in this pool", "objects");
                this.registerGaugeForObject(meterRegistry, (ObjectName)objectName, "NumActive", "num.active", (Tags)tags, "The number of instances currently active in this pool", "objects");
                this.registerGaugeForObject(meterRegistry, (ObjectName)objectName, "NumWaiters", "num.waiters", (Tags)tags, "The estimate of the number of threads currently blocked waiting for an object from the pool", "threads");
                this.registerFunctionCounterForObject(meterRegistry, (ObjectName)objectName, "CreatedCount", "created", (Tags)tags, "The total number of objects created for this pool over the lifetime of the pool", "objects");
                this.registerFunctionCounterForObject(meterRegistry, (ObjectName)objectName, "BorrowedCount", "borrowed", (Tags)tags, "The total number of objects successfully borrowed from this pool over the lifetime of the pool", "objects");
                this.registerFunctionCounterForObject(meterRegistry, (ObjectName)objectName, "ReturnedCount", "returned", (Tags)tags, "The total number of objects returned to this pool over the lifetime of the pool", "objects");
                this.registerFunctionCounterForObject(meterRegistry, (ObjectName)objectName, "DestroyedCount", "destroyed", (Tags)tags, "The total number of objects destroyed by this pool over the lifetime of the pool", "objects");
                this.registerFunctionCounterForObject(meterRegistry, (ObjectName)objectName, "DestroyedByEvictorCount", "destroyed.by.evictor", (Tags)tags, "The total number of objects destroyed by the evictor associated with this pool over the lifetime of the pool", "objects");
                this.registerFunctionCounterForObject(meterRegistry, (ObjectName)objectName, "DestroyedByBorrowValidationCount", "destroyed.by.borrow.validation", (Tags)tags, "The total number of objects destroyed by this pool as a result of failing validation during borrowObject() over the lifetime of the pool", "objects");
                this.registerTimeGaugeForObject(meterRegistry, (ObjectName)objectName, "MaxBorrowWaitTimeMillis", "max.borrow.wait", (Tags)tags, "The maximum time a thread has waited to borrow objects from the pool");
                this.registerTimeGaugeForObject(meterRegistry, (ObjectName)objectName, "MeanActiveTimeMillis", "mean.active", (Tags)tags, "The mean time objects are active");
                this.registerTimeGaugeForObject(meterRegistry, (ObjectName)objectName, "MeanIdleTimeMillis", "mean.idle", (Tags)tags, "The mean time objects are idle");
                this.registerTimeGaugeForObject(meterRegistry, (ObjectName)objectName, "MeanBorrowWaitTimeMillis", "mean.borrow.wait", (Tags)tags, "The mean time threads wait to borrow an object");
            });
        }
    }

    private Iterable<Tag> nameTag(ObjectName objectName, String string) throws AttributeNotFoundException, MBeanException, ReflectionException, InstanceNotFoundException {
        Tags tags = Tags.of("name", objectName.getKeyProperty("name"), "type", string);
        if (Objects.equals(string, "GenericObjectPool")) {
            String string2 = this.mBeanServer.getAttribute(objectName, "FactoryType").toString();
            tags = Tags.concat((Iterable<? extends Tag>)tags, "factoryType", string2);
        }
        return tags;
    }

    private void registerMetricsEventually(String string, BiConsumer<ObjectName, Tags> biConsumer) {
        try {
            Set<ObjectName> set = this.mBeanServer.queryNames(new ObjectName("com.contrastsecurity.thirdparty.org.apache.commons.pool2:type=" + string + ",*"), null);
            for (ObjectName objectName : set) {
                List<Tag> list = Collections.emptyList();
                try {
                    list = this.nameTag(objectName, string);
                }
                catch (Exception exception) {
                    log.error("exception in determining name tag", exception);
                }
                biConsumer.accept(objectName, Tags.concat(this.tags, list));
            }
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            throw new RuntimeException("Error registering commons pool2 based metrics", malformedObjectNameException);
        }
        this.registerNotificationListener(string, biConsumer);
    }

    private void registerNotificationListener(String string, BiConsumer<ObjectName, Tags> biConsumer) {
        NotificationListener notificationListener = (notification, object) -> this.executor.execute(() -> {
            MBeanServerNotification mBeanServerNotification = (MBeanServerNotification)notification;
            ObjectName objectName = mBeanServerNotification.getMBeanName();
            Iterable<Tag> iterable = Collections.emptyList();
            int n2 = 3;
            for (int i2 = 0; i2 < n2; ++i2) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException(interruptedException);
                }
                try {
                    iterable = this.nameTag(objectName, string);
                    break;
                }
                catch (AttributeNotFoundException | InstanceNotFoundException | MBeanException | ReflectionException jMException) {
                    if (i2 != n2 - 1) continue;
                    log.error("can not set name tag", jMException);
                    continue;
                }
            }
            biConsumer.accept(objectName, Tags.concat(this.tags, iterable));
        });
        NotificationFilter notificationFilter = notification -> {
            if (!"JMX.mbean.registered".equals(notification.getType())) {
                return false;
            }
            ObjectName objectName = ((MBeanServerNotification)notification).getMBeanName();
            return objectName.getDomain().equals(JMX_DOMAIN) && objectName.getKeyProperty("type").equals(string);
        };
        try {
            this.mBeanServer.addNotificationListener(MBeanServerDelegate.DELEGATE_NAME, notificationListener, notificationFilter, null);
            this.notificationListenerCleanUpRunnables.add(() -> {
                try {
                    this.mBeanServer.removeNotificationListener(MBeanServerDelegate.DELEGATE_NAME, notificationListener);
                }
                catch (InstanceNotFoundException | ListenerNotFoundException operationsException) {
                    // empty catch block
                }
            });
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            // empty catch block
        }
    }

    @Override
    public void close() {
        this.notificationListenerCleanUpRunnables.forEach(Runnable::run);
        this.executor.shutdown();
    }

    private void registerGaugeForObject(MeterRegistry meterRegistry, ObjectName objectName, String string, String string2, Tags tags, String string3, @Nullable String string4) {
        AtomicReference<Gauge> atomicReference = new AtomicReference<Gauge>();
        atomicReference.set(Gauge.builder(METRIC_NAME_PREFIX + string2, this.mBeanServer, this.getJmxAttribute(meterRegistry, atomicReference, objectName, string)).description(string3).baseUnit(string4).tags(tags).register(meterRegistry));
    }

    private void registerFunctionCounterForObject(MeterRegistry meterRegistry, ObjectName objectName, String string, String string2, Tags tags, String string3, @Nullable String string4) {
        AtomicReference<FunctionCounter> atomicReference = new AtomicReference<FunctionCounter>();
        atomicReference.set(FunctionCounter.builder(METRIC_NAME_PREFIX + string2, this.mBeanServer, this.getJmxAttribute(meterRegistry, atomicReference, objectName, string)).description(string3).baseUnit(string4).tags(tags).register(meterRegistry));
    }

    private void registerTimeGaugeForObject(MeterRegistry meterRegistry, ObjectName objectName, String string, String string2, Tags tags, String string3) {
        AtomicReference<TimeGauge> atomicReference = new AtomicReference<TimeGauge>();
        atomicReference.set(TimeGauge.builder(METRIC_NAME_PREFIX + string2, this.mBeanServer, TimeUnit.MILLISECONDS, this.getJmxAttribute(meterRegistry, atomicReference, objectName, string)).description(string3).tags(tags).register(meterRegistry));
    }

    private ToDoubleFunction<MBeanServer> getJmxAttribute(MeterRegistry meterRegistry, AtomicReference<? extends Meter> atomicReference, ObjectName objectName, String string) {
        return mBeanServer -> this.safeDouble(() -> {
            if (!mBeanServer.isRegistered(objectName)) {
                meterRegistry.remove((Meter)atomicReference.get());
            }
            return mBeanServer.getAttribute(objectName, string);
        });
    }

    private double safeDouble(Callable<Object> callable) {
        try {
            return Double.parseDouble(callable.call().toString());
        }
        catch (Exception exception) {
            return Double.NaN;
        }
    }
}

