/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.micrometer.core.instrument.binder.db;

import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.MeterRegistry;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Tag;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Timer;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.util.StringUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.jooq.ExecuteContext;
import org.jooq.exception.DataAccessException;
import org.jooq.impl.DefaultExecuteListener;

class JooqExecuteListener
extends DefaultExecuteListener {
    private final MeterRegistry registry;
    private final Iterable<Tag> tags;
    private final Supplier<Iterable<Tag>> queryTagsSupplier;
    private final Object sampleLock = new Object();
    private final Map<ExecuteContext, Timer.Sample> sampleByExecuteContext = new HashMap<ExecuteContext, Timer.Sample>();

    public JooqExecuteListener(MeterRegistry meterRegistry, Iterable<Tag> iterable, Supplier<Iterable<Tag>> supplier) {
        this.registry = meterRegistry;
        this.tags = iterable;
        this.queryTagsSupplier = supplier;
    }

    public void start(ExecuteContext executeContext) {
        this.startTimer(executeContext);
    }

    public void executeStart(ExecuteContext executeContext) {
        this.startTimer(executeContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startTimer(ExecuteContext executeContext) {
        Timer.Sample sample = Timer.start(this.registry);
        Object object = this.sampleLock;
        synchronized (object) {
            this.sampleByExecuteContext.put(executeContext, sample);
        }
    }

    public void executeEnd(ExecuteContext executeContext) {
        this.stopTimerIfStillRunning(executeContext);
    }

    public void end(ExecuteContext executeContext) {
        this.stopTimerIfStillRunning(executeContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopTimerIfStillRunning(ExecuteContext executeContext) {
        Timer.Sample sample;
        Iterable<Tag> iterable = this.queryTagsSupplier.get();
        if (iterable == null) {
            return;
        }
        Object object = this.sampleLock;
        synchronized (object) {
            sample = this.sampleByExecuteContext.remove(executeContext);
        }
        if (sample == null) {
            return;
        }
        object = "none";
        String string = "none";
        RuntimeException runtimeException = executeContext.exception();
        if (runtimeException != null) {
            if (runtimeException instanceof DataAccessException) {
                DataAccessException dataAccessException = (DataAccessException)runtimeException;
                object = dataAccessException.sqlStateClass().name().toLowerCase().replace('_', ' ');
                string = dataAccessException.sqlStateSubclass().name().toLowerCase().replace('_', ' ');
                if (string.contains("no subclass")) {
                    string = "none";
                }
            } else {
                String string2 = runtimeException.getClass().getSimpleName();
                object = StringUtils.isNotBlank(string2) ? string2 : runtimeException.getClass().getName();
            }
        }
        sample.stop(((Timer.Builder)((Timer.Builder)Timer.builder("jooq.query").description("Execution time of a SQL query performed with JOOQ").tags((Iterable)iterable)).tag("type", executeContext.type().name().toLowerCase()).tag("exception", (String)object).tag("exception.subclass", string).tags((Iterable)this.tags)).register(this.registry));
    }
}

