/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.micrometer.core.instrument.binder.db;

import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.FunctionCounter;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Gauge;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.MeterRegistry;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Tag;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Tags;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.binder.MeterBinder;
import com.contrastsecurity.thirdparty.io.micrometer.core.lang.NonNullApi;
import com.contrastsecurity.thirdparty.io.micrometer.core.lang.NonNullFields;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.DoubleSupplier;
import javax.sql.DataSource;

@NonNullApi
@NonNullFields
public class PostgreSQLDatabaseMetrics
implements MeterBinder {
    private static final String SELECT = "SELECT ";
    private static final String QUERY_DEAD_TUPLE_COUNT = PostgreSQLDatabaseMetrics.getUserTableQuery("n_dead_tup");
    private static final String QUERY_TIMED_CHECKPOINTS_COUNT = PostgreSQLDatabaseMetrics.getBgWriterQuery("checkpoints_timed");
    private static final String QUERY_REQUESTED_CHECKPOINTS_COUNT = PostgreSQLDatabaseMetrics.getBgWriterQuery("checkpoints_req");
    private static final String QUERY_BUFFERS_CLEAN = PostgreSQLDatabaseMetrics.getBgWriterQuery("buffers_clean");
    private static final String QUERY_BUFFERS_BACKEND = PostgreSQLDatabaseMetrics.getBgWriterQuery("buffers_backend");
    private static final String QUERY_BUFFERS_CHECKPOINT = PostgreSQLDatabaseMetrics.getBgWriterQuery("buffers_checkpoint");
    private final String database;
    private final DataSource postgresDataSource;
    private final Iterable<Tag> tags;
    private final Map<String, Double> beforeResetValuesCacheMap;
    private final Map<String, Double> previousValueCacheMap;
    private final String queryConnectionCount;
    private final String queryReadCount;
    private final String queryInsertCount;
    private final String queryTempBytes;
    private final String queryUpdateCount;
    private final String queryDeleteCount;
    private final String queryBlockHits;
    private final String queryBlockReads;
    private final String queryTransactionCount;

    public PostgreSQLDatabaseMetrics(DataSource dataSource, String string) {
        this(dataSource, string, Tags.empty());
    }

    public PostgreSQLDatabaseMetrics(DataSource dataSource, String string, Iterable<Tag> iterable) {
        this.postgresDataSource = dataSource;
        this.database = string;
        this.tags = Tags.of(iterable).and(PostgreSQLDatabaseMetrics.createDbTag(string));
        this.beforeResetValuesCacheMap = new ConcurrentHashMap<String, Double>();
        this.previousValueCacheMap = new ConcurrentHashMap<String, Double>();
        this.queryConnectionCount = PostgreSQLDatabaseMetrics.getDBStatQuery(string, "SUM(numbackends)");
        this.queryReadCount = PostgreSQLDatabaseMetrics.getDBStatQuery(string, "tup_fetched");
        this.queryInsertCount = PostgreSQLDatabaseMetrics.getDBStatQuery(string, "tup_inserted");
        this.queryTempBytes = PostgreSQLDatabaseMetrics.getDBStatQuery(string, "temp_bytes");
        this.queryUpdateCount = PostgreSQLDatabaseMetrics.getDBStatQuery(string, "tup_updated");
        this.queryDeleteCount = PostgreSQLDatabaseMetrics.getDBStatQuery(string, "tup_deleted");
        this.queryBlockHits = PostgreSQLDatabaseMetrics.getDBStatQuery(string, "blks_hit");
        this.queryBlockReads = PostgreSQLDatabaseMetrics.getDBStatQuery(string, "blks_read");
        this.queryTransactionCount = PostgreSQLDatabaseMetrics.getDBStatQuery(string, "xact_commit + xact_rollback");
    }

    private static Tag createDbTag(String string) {
        return Tag.of("database", string);
    }

    @Override
    public void bindTo(MeterRegistry meterRegistry) {
        Gauge.builder("postgres.size", this.postgresDataSource, dataSource -> this.getDatabaseSize().longValue()).tags(this.tags).description("The database size").register(meterRegistry);
        Gauge.builder("postgres.connections", this.postgresDataSource, dataSource -> this.getConnectionCount().longValue()).tags(this.tags).description("Number of active connections to the given db").register(meterRegistry);
        FunctionCounter.builder("postgres.blocks.hits", this.postgresDataSource, dataSource -> this.resettableFunctionalCounter("postgres.blocks.hits", this::getBlockHits)).tags(this.tags).description("Number of times disk blocks were found already in the buffer cache, so that a read was not necessary").register(meterRegistry);
        FunctionCounter.builder("postgres.blocks.reads", this.postgresDataSource, dataSource -> this.resettableFunctionalCounter("postgres.blocks.reads", this::getBlockReads)).tags(this.tags).description("Number of disk blocks read in this database").register(meterRegistry);
        FunctionCounter.builder("postgres.transactions", this.postgresDataSource, dataSource -> this.resettableFunctionalCounter("postgres.transactions", this::getTransactionCount)).tags(this.tags).description("Total number of transactions executed (commits + rollbacks)").register(meterRegistry);
        Gauge.builder("postgres.locks", this.postgresDataSource, dataSource -> this.getLockCount().longValue()).tags(this.tags).description("Number of locks on the given db").register(meterRegistry);
        FunctionCounter.builder("postgres.temp.writes", this.postgresDataSource, dataSource -> this.resettableFunctionalCounter("postgres.temp.writes", this::getTempBytes)).tags(this.tags).description("The total amount of temporary writes to disk to execute queries").baseUnit("bytes").register(meterRegistry);
        this.registerRowCountMetrics(meterRegistry);
        this.registerCheckpointMetrics(meterRegistry);
    }

    private void registerRowCountMetrics(MeterRegistry meterRegistry) {
        FunctionCounter.builder("postgres.rows.fetched", this.postgresDataSource, dataSource -> this.resettableFunctionalCounter("postgres.rows.fetched", this::getReadCount)).tags(this.tags).description("Number of rows fetched from the db").register(meterRegistry);
        FunctionCounter.builder("postgres.rows.inserted", this.postgresDataSource, dataSource -> this.resettableFunctionalCounter("postgres.rows.inserted", this::getInsertCount)).tags(this.tags).description("Number of rows inserted from the db").register(meterRegistry);
        FunctionCounter.builder("postgres.rows.updated", this.postgresDataSource, dataSource -> this.resettableFunctionalCounter("postgres.rows.updated", this::getUpdateCount)).tags(this.tags).description("Number of rows updated from the db").register(meterRegistry);
        FunctionCounter.builder("postgres.rows.deleted", this.postgresDataSource, dataSource -> this.resettableFunctionalCounter("postgres.rows.deleted", this::getDeleteCount)).tags(this.tags).description("Number of rows deleted from the db").register(meterRegistry);
        Gauge.builder("postgres.rows.dead", this.postgresDataSource, dataSource -> this.getDeadTupleCount().longValue()).tags(this.tags).description("Total number of dead rows in the current database").register(meterRegistry);
    }

    private void registerCheckpointMetrics(MeterRegistry meterRegistry) {
        FunctionCounter.builder("postgres.checkpoints.timed", this.postgresDataSource, dataSource -> this.resettableFunctionalCounter("postgres.checkpoints.timed", this::getTimedCheckpointsCount)).tags(this.tags).description("Number of checkpoints timed").register(meterRegistry);
        FunctionCounter.builder("postgres.checkpoints.requested", this.postgresDataSource, dataSource -> this.resettableFunctionalCounter("postgres.checkpoints.requested", this::getRequestedCheckpointsCount)).tags(this.tags).description("Number of checkpoints requested").register(meterRegistry);
        FunctionCounter.builder("postgres.buffers.checkpoint", this.postgresDataSource, dataSource -> this.resettableFunctionalCounter("postgres.buffers.checkpoint", this::getBuffersCheckpoint)).tags(this.tags).description("Number of buffers written during checkpoints").register(meterRegistry);
        FunctionCounter.builder("postgres.buffers.clean", this.postgresDataSource, dataSource -> this.resettableFunctionalCounter("postgres.buffers.clean", this::getBuffersClean)).tags(this.tags).description("Number of buffers written by the background writer").register(meterRegistry);
        FunctionCounter.builder("postgres.buffers.backend", this.postgresDataSource, dataSource -> this.resettableFunctionalCounter("postgres.buffers.backend", this::getBuffersBackend)).tags(this.tags).description("Number of buffers written directly by a backend").register(meterRegistry);
    }

    private Long getDatabaseSize() {
        return this.runQuery("SELECT pg_database_size('" + this.database + "')");
    }

    private Long getLockCount() {
        return this.runQuery("SELECT count(*) FROM pg_locks l JOIN pg_database d ON l.DATABASE=d.oid WHERE d.datname='" + this.database + "'");
    }

    private Long getConnectionCount() {
        return this.runQuery(this.queryConnectionCount);
    }

    private Long getReadCount() {
        return this.runQuery(this.queryReadCount);
    }

    private Long getInsertCount() {
        return this.runQuery(this.queryInsertCount);
    }

    private Long getTempBytes() {
        return this.runQuery(this.queryTempBytes);
    }

    private Long getUpdateCount() {
        return this.runQuery(this.queryUpdateCount);
    }

    private Long getDeleteCount() {
        return this.runQuery(this.queryDeleteCount);
    }

    private Long getBlockHits() {
        return this.runQuery(this.queryBlockHits);
    }

    private Long getBlockReads() {
        return this.runQuery(this.queryBlockReads);
    }

    private Long getTransactionCount() {
        return this.runQuery(this.queryTransactionCount);
    }

    private Long getDeadTupleCount() {
        return this.runQuery(QUERY_DEAD_TUPLE_COUNT);
    }

    private Long getTimedCheckpointsCount() {
        return this.runQuery(QUERY_TIMED_CHECKPOINTS_COUNT);
    }

    private Long getRequestedCheckpointsCount() {
        return this.runQuery(QUERY_REQUESTED_CHECKPOINTS_COUNT);
    }

    private Long getBuffersClean() {
        return this.runQuery(QUERY_BUFFERS_CLEAN);
    }

    private Long getBuffersBackend() {
        return this.runQuery(QUERY_BUFFERS_BACKEND);
    }

    private Long getBuffersCheckpoint() {
        return this.runQuery(QUERY_BUFFERS_CHECKPOINT);
    }

    Double resettableFunctionalCounter(String string, DoubleSupplier doubleSupplier) {
        Double d2 = doubleSupplier.getAsDouble();
        Double d3 = this.previousValueCacheMap.getOrDefault(string, 0.0);
        Double d4 = this.beforeResetValuesCacheMap.getOrDefault(string, 0.0);
        Double d5 = d2 + d4;
        if (d5 < d3) {
            this.beforeResetValuesCacheMap.put(string, d3);
            d5 = d3 + d2;
        }
        this.previousValueCacheMap.put(string, d5);
        return d5;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Long runQuery(String string) {
        try (Connection connection = this.postgresDataSource.getConnection();
             Statement statement = connection.createStatement();
             ResultSet resultSet = statement.executeQuery(string);){
            if (!resultSet.next()) return 0L;
            Long l2 = resultSet.getObject(1, Long.class);
            return l2;
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return 0L;
    }

    private static String getDBStatQuery(String string, String string2) {
        return SELECT + string2 + " FROM pg_stat_database WHERE datname = '" + string + "'";
    }

    private static String getUserTableQuery(String string) {
        return SELECT + string + " FROM pg_stat_user_tables";
    }

    private static String getBgWriterQuery(String string) {
        return SELECT + string + " FROM pg_stat_bgwriter";
    }
}

