/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.micrometer.core.instrument.binder.httpcomponents;

import com.contrastsecurity.thirdparty.io.micrometer.core.annotation.Incubating;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.MeterRegistry;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Tag;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Tags;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Timer;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.binder.httpcomponents.DefaultUriMapper;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.binder.httpcomponents.HttpContextUtils;
import com.contrastsecurity.thirdparty.org.apache.http.HttpClientConnection;
import com.contrastsecurity.thirdparty.org.apache.http.HttpException;
import com.contrastsecurity.thirdparty.org.apache.http.HttpRequest;
import com.contrastsecurity.thirdparty.org.apache.http.HttpResponse;
import com.contrastsecurity.thirdparty.org.apache.http.protocol.HttpContext;
import com.contrastsecurity.thirdparty.org.apache.http.protocol.HttpRequestExecutor;
import java.io.IOException;
import java.util.Collections;
import java.util.Optional;
import java.util.function.Function;

@Incubating(since="1.2.0")
public class MicrometerHttpRequestExecutor
extends HttpRequestExecutor {
    @Deprecated
    public static final String DEFAULT_URI_PATTERN_HEADER = "URI_PATTERN";
    private static final String METER_NAME = "httpcomponents.httpclient.request";
    private static final Tag STATUS_UNKNOWN = Tag.of("status", "UNKNOWN");
    private static final Tag STATUS_CLIENT_ERROR = Tag.of("status", "CLIENT_ERROR");
    private static final Tag STATUS_IO_ERROR = Tag.of("status", "IO_ERROR");
    private final MeterRegistry registry;
    private final Function<HttpRequest, String> uriMapper;
    private final Iterable<Tag> extraTags;
    private final boolean exportTagsForRoute;

    private MicrometerHttpRequestExecutor(int n2, MeterRegistry meterRegistry, Function<HttpRequest, String> function, Iterable<Tag> iterable, boolean bl) {
        super(n2);
        this.registry = Optional.ofNullable(meterRegistry).orElseThrow(() -> new IllegalArgumentException("registry is required but has been initialized with null"));
        this.uriMapper = Optional.ofNullable(function).orElseThrow(() -> new IllegalArgumentException("uriMapper is required but has been initialized with null"));
        this.extraTags = Optional.ofNullable(iterable).orElse(Collections.emptyList());
        this.exportTagsForRoute = bl;
    }

    public static Builder builder(MeterRegistry meterRegistry) {
        return new Builder(meterRegistry);
    }

    @Override
    public HttpResponse execute(HttpRequest httpRequest, HttpClientConnection httpClientConnection, HttpContext httpContext) throws IOException, HttpException {
        HttpResponse httpResponse;
        Timer.Sample sample = Timer.start(this.registry);
        Tag tag = Tag.of("method", httpRequest.getRequestLine().getMethod());
        Tag tag2 = Tag.of("uri", this.uriMapper.apply(httpRequest));
        Tag tag3 = STATUS_UNKNOWN;
        Tags tags = this.exportTagsForRoute ? HttpContextUtils.generateTagsForRoute(httpContext) : Tags.empty();
        try {
            HttpResponse httpResponse2 = super.execute(httpRequest, httpClientConnection, httpContext);
            tag3 = httpResponse2 != null ? Tag.of("status", Integer.toString(httpResponse2.getStatusLine().getStatusCode())) : STATUS_CLIENT_ERROR;
            httpResponse = httpResponse2;
        }
        catch (HttpException | IOException | RuntimeException exception) {
            try {
                tag3 = STATUS_IO_ERROR;
                throw exception;
            }
            catch (Throwable throwable) {
                Tags tags2 = Tags.of(this.extraTags).and(tags).and(tag2, tag, tag3);
                sample.stop(((Timer.Builder)Timer.builder(METER_NAME).description("Duration of Apache HttpClient request execution").tags((Iterable)tags2)).register(this.registry));
                throw throwable;
            }
        }
        Tags tags3 = Tags.of(this.extraTags).and(tags).and(tag2, tag, tag3);
        sample.stop(((Timer.Builder)Timer.builder(METER_NAME).description("Duration of Apache HttpClient request execution").tags((Iterable)tags3)).register(this.registry));
        return httpResponse;
    }

    public static class Builder {
        private final MeterRegistry registry;
        private int waitForContinue = 3000;
        private Iterable<Tag> tags = Collections.emptyList();
        private Function<HttpRequest, String> uriMapper = new DefaultUriMapper();
        private boolean exportTagsForRoute = false;

        Builder(MeterRegistry meterRegistry) {
            this.registry = meterRegistry;
        }

        public Builder waitForContinue(int n2) {
            this.waitForContinue = n2;
            return this;
        }

        public Builder tags(Iterable<Tag> iterable) {
            this.tags = iterable;
            return this;
        }

        public Builder uriMapper(Function<HttpRequest, String> function) {
            this.uriMapper = function;
            return this;
        }

        public Builder exportTagsForRoute(boolean bl) {
            this.exportTagsForRoute = bl;
            return this;
        }

        public MicrometerHttpRequestExecutor build() {
            return new MicrometerHttpRequestExecutor(this.waitForContinue, this.registry, this.uriMapper, this.tags, this.exportTagsForRoute);
        }
    }
}

