/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.micrometer.core.instrument.binder.jetty;

import com.contrastsecurity.thirdparty.io.micrometer.core.annotation.Incubating;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.DistributionSummary;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.MeterRegistry;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Tag;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Timer;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.binder.jetty.JettyClientTagsProvider;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.config.MeterFilter;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.internal.OnlyOnceLoggingDenyMeterFilter;
import java.util.Optional;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.client.api.Request;

@Incubating(since="1.5.0")
public class JettyClientMetrics
implements Request.Listener {
    private final MeterRegistry registry;
    private final JettyClientTagsProvider tagsProvider;
    private final String timingMetricName;
    private final String contentSizeMetricName;

    protected JettyClientMetrics(MeterRegistry meterRegistry, JettyClientTagsProvider jettyClientTagsProvider, String string, String string2, int n2) {
        this.registry = meterRegistry;
        this.tagsProvider = jettyClientTagsProvider;
        this.timingMetricName = string;
        this.contentSizeMetricName = string2;
        OnlyOnceLoggingDenyMeterFilter onlyOnceLoggingDenyMeterFilter = new OnlyOnceLoggingDenyMeterFilter(() -> String.format("Reached the maximum number of URI tags for '%s'.", string));
        OnlyOnceLoggingDenyMeterFilter onlyOnceLoggingDenyMeterFilter2 = new OnlyOnceLoggingDenyMeterFilter(() -> String.format("Reached the maximum number of URI tags for '%s'.", string2));
        meterRegistry.config().meterFilter(MeterFilter.maximumAllowableTags(this.timingMetricName, "uri", n2, onlyOnceLoggingDenyMeterFilter)).meterFilter(MeterFilter.maximumAllowableTags(this.contentSizeMetricName, "uri", n2, onlyOnceLoggingDenyMeterFilter2));
    }

    public void onQueued(Request request) {
        Timer.Sample sample = Timer.start(this.registry);
        request.onComplete(result -> {
            long l2 = Optional.ofNullable(result.getRequest().getContent()).map(ContentProvider::getLength).orElse(0L);
            Iterable<Tag> iterable = this.tagsProvider.httpRequestTags(result);
            if (l2 >= 0L) {
                DistributionSummary.builder(this.contentSizeMetricName).description("Content sizes for Jetty HTTP client requests").tags(iterable).register(this.registry).record(l2);
            }
            sample.stop(((Timer.Builder)Timer.builder(this.timingMetricName).description("Jetty HTTP client request timing").tags((Iterable)iterable)).register(this.registry));
        });
    }

    public static Builder builder(MeterRegistry meterRegistry, JettyClientTagsProvider jettyClientTagsProvider) {
        return new Builder(meterRegistry, jettyClientTagsProvider);
    }

    public static class Builder {
        private final MeterRegistry registry;
        private final JettyClientTagsProvider tagsProvider;
        private String timingMetricName = "jetty.client.requests";
        private String contentSizeMetricName = "jetty.client.request.size";
        private int maxUriTags = 1000;

        Builder(MeterRegistry meterRegistry, JettyClientTagsProvider jettyClientTagsProvider) {
            this.registry = meterRegistry;
            this.tagsProvider = jettyClientTagsProvider;
        }

        public Builder timingMetricName(String string) {
            this.timingMetricName = string;
            return this;
        }

        public Builder contentSizeMetricName(String string) {
            this.contentSizeMetricName = string;
            return this;
        }

        public Builder maxUriTags(int n2) {
            this.maxUriTags = n2;
            return this;
        }

        public JettyClientMetrics build() {
            return new JettyClientMetrics(this.registry, this.tagsProvider, this.timingMetricName, this.contentSizeMetricName, this.maxUriTags);
        }
    }
}

