/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.micrometer.core.instrument.binder.jvm;

import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.FunctionCounter;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Gauge;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.MeterRegistry;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Tag;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.binder.MeterBinder;
import com.contrastsecurity.thirdparty.io.micrometer.core.lang.NonNullApi;
import com.contrastsecurity.thirdparty.io.micrometer.core.lang.NonNullFields;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.ManagementFactory;
import java.util.Collections;

@NonNullApi
@NonNullFields
public class ClassLoaderMetrics
implements MeterBinder {
    private final Iterable<Tag> tags;

    public ClassLoaderMetrics() {
        this(Collections.emptyList());
    }

    public ClassLoaderMetrics(Iterable<Tag> iterable) {
        this.tags = iterable;
    }

    @Override
    public void bindTo(MeterRegistry meterRegistry) {
        ClassLoadingMXBean classLoadingMXBean = ManagementFactory.getClassLoadingMXBean();
        Gauge.builder("jvm.classes.loaded", classLoadingMXBean, ClassLoadingMXBean::getLoadedClassCount).tags(this.tags).description("The number of classes that are currently loaded in the Java virtual machine").baseUnit("classes").register(meterRegistry);
        FunctionCounter.builder("jvm.classes.unloaded", classLoadingMXBean, ClassLoadingMXBean::getUnloadedClassCount).tags(this.tags).description("The total number of classes unloaded since the Java virtual machine has started execution").baseUnit("classes").register(meterRegistry);
    }
}

