/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.micrometer.core.instrument.binder.jvm;

import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Gauge;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.MeterRegistry;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Tag;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.binder.MeterBinder;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.binder.jvm.JvmMemory;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.distribution.TimeWindowSum;
import com.contrastsecurity.thirdparty.io.micrometer.core.lang.NonNull;
import com.sun.management.GarbageCollectionNotificationInfo;
import com.sun.management.GcInfo;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.management.ListenerNotFoundException;
import javax.management.NotificationEmitter;
import javax.management.NotificationListener;
import javax.management.openmbean.CompositeData;

public class JvmHeapPressureMetrics
implements MeterBinder,
AutoCloseable {
    private final Iterable<Tag> tags;
    private final List<Runnable> notificationListenerCleanUpRunnables = new CopyOnWriteArrayList<Runnable>();
    private final long startOfMonitoring = System.nanoTime();
    private final Duration lookback;
    private final TimeWindowSum gcPauseSum;
    private final AtomicReference<Double> lastLongLivedPoolUsageAfterGc = new AtomicReference<Double>(0.0);
    private final Set<String> longLivedPoolNames;

    public JvmHeapPressureMetrics() {
        this(Collections.emptyList(), Duration.ofMinutes(5L), Duration.ofMinutes(1L));
    }

    public JvmHeapPressureMetrics(Iterable<Tag> iterable, Duration duration, Duration duration2) {
        this.tags = iterable;
        this.lookback = duration;
        this.gcPauseSum = new TimeWindowSum((int)duration.dividedBy(duration2.toMillis()).toMillis(), duration2);
        this.longLivedPoolNames = JvmMemory.getLongLivedHeapPools().map(MemoryPoolMXBean::getName).collect(Collectors.toSet());
        this.monitor();
    }

    @Override
    public void bindTo(@NonNull MeterRegistry meterRegistry) {
        if (!this.longLivedPoolNames.isEmpty()) {
            Gauge.builder("jvm.memory.usage.after.gc", this.lastLongLivedPoolUsageAfterGc, AtomicReference::get).tags(this.tags).tag("area", "heap").tag("pool", "long-lived").description("The percentage of long-lived heap pool used after the last GC event, in the range [0..1]").baseUnit("percent").register(meterRegistry);
        }
        Gauge.builder("jvm.gc.overhead", this.gcPauseSum, timeWindowSum -> {
            double d2 = (double)Math.min(System.nanoTime() - this.startOfMonitoring, this.lookback.toNanos()) / 1000000.0;
            return this.gcPauseSum.poll() / d2;
        }).tags(this.tags).description("An approximation of the percent of CPU time used by GC activities over the last lookback period or since monitoring began, whichever is shorter, in the range [0..1]").baseUnit("percent").register(meterRegistry);
    }

    private void monitor() {
        for (GarbageCollectorMXBean garbageCollectorMXBean : ManagementFactory.getGarbageCollectorMXBeans()) {
            if (!(garbageCollectorMXBean instanceof NotificationEmitter)) continue;
            NotificationListener notificationListener = (notification, object) -> {
                CompositeData compositeData = (CompositeData)notification.getUserData();
                GarbageCollectionNotificationInfo garbageCollectionNotificationInfo = GarbageCollectionNotificationInfo.from(compositeData);
                String string2 = garbageCollectionNotificationInfo.getGcCause();
                GcInfo gcInfo = garbageCollectionNotificationInfo.getGcInfo();
                long l2 = gcInfo.getDuration();
                if (!JvmMemory.isConcurrentPhase(string2, garbageCollectionNotificationInfo.getGcName())) {
                    this.gcPauseSum.record(l2);
                }
                Map<String, MemoryUsage> map = gcInfo.getMemoryUsageAfterGc();
                if (!this.longLivedPoolNames.isEmpty()) {
                    long l3 = this.longLivedPoolNames.stream().mapToLong(string -> ((MemoryUsage)map.get(string)).getUsed()).sum();
                    double d2 = this.longLivedPoolNames.stream().mapToLong(string -> ((MemoryUsage)map.get(string)).getMax()).sum();
                    this.lastLongLivedPoolUsageAfterGc.set((double)l3 / d2);
                }
            };
            NotificationEmitter notificationEmitter = (NotificationEmitter)((Object)garbageCollectorMXBean);
            notificationEmitter.addNotificationListener(notificationListener, notification -> notification.getType().equals("com.sun.management.gc.notification"), null);
            this.notificationListenerCleanUpRunnables.add(() -> {
                try {
                    notificationEmitter.removeNotificationListener(notificationListener);
                }
                catch (ListenerNotFoundException listenerNotFoundException) {
                    // empty catch block
                }
            });
        }
    }

    @Override
    public void close() {
        this.notificationListenerCleanUpRunnables.forEach(Runnable::run);
    }
}

