/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.micrometer.core.instrument.binder.jvm;

import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Gauge;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.MeterRegistry;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Tag;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Tags;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.binder.MeterBinder;
import com.contrastsecurity.thirdparty.io.micrometer.core.lang.NonNullApi;
import com.contrastsecurity.thirdparty.io.micrometer.core.lang.NonNullFields;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.Arrays;
import java.util.Collections;

@NonNullApi
@NonNullFields
public class JvmThreadMetrics
implements MeterBinder {
    private final Iterable<Tag> tags;

    public JvmThreadMetrics() {
        this(Collections.emptyList());
    }

    public JvmThreadMetrics(Iterable<Tag> iterable) {
        this.tags = iterable;
    }

    @Override
    public void bindTo(MeterRegistry meterRegistry) {
        ThreadMXBean threadMXBean2 = ManagementFactory.getThreadMXBean();
        Gauge.builder("jvm.threads.peak", threadMXBean2, ThreadMXBean::getPeakThreadCount).tags(this.tags).description("The peak live thread count since the Java virtual machine started or peak was reset").baseUnit("threads").register(meterRegistry);
        Gauge.builder("jvm.threads.daemon", threadMXBean2, ThreadMXBean::getDaemonThreadCount).tags(this.tags).description("The current number of live daemon threads").baseUnit("threads").register(meterRegistry);
        Gauge.builder("jvm.threads.live", threadMXBean2, ThreadMXBean::getThreadCount).tags(this.tags).description("The current number of live threads including both daemon and non-daemon threads").baseUnit("threads").register(meterRegistry);
        try {
            threadMXBean2.getAllThreadIds();
            for (Thread.State state : Thread.State.values()) {
                Gauge.builder("jvm.threads.states", threadMXBean2, threadMXBean -> JvmThreadMetrics.getThreadStateCount(threadMXBean, state)).tags(Tags.concat(this.tags, "state", JvmThreadMetrics.getStateTagValue(state))).description("The current number of threads having " + (Object)((Object)state) + " state").baseUnit("threads").register(meterRegistry);
            }
        }
        catch (Error error) {
            // empty catch block
        }
    }

    static long getThreadStateCount(ThreadMXBean threadMXBean, Thread.State state) {
        return Arrays.stream(threadMXBean.getThreadInfo(threadMXBean.getAllThreadIds())).filter(threadInfo -> threadInfo != null && threadInfo.getThreadState() == state).count();
    }

    private static String getStateTagValue(Thread.State state) {
        return state.name().toLowerCase().replace("_", "-");
    }
}

