/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.micrometer.core.instrument.binder.kafka;

import com.contrastsecurity.thirdparty.io.micrometer.core.annotation.Incubating;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.FunctionCounter;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Gauge;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Meter;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.MeterRegistry;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Tag;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Tags;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.binder.MeterBinder;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.util.NamedThreadFactory;
import com.contrastsecurity.thirdparty.io.micrometer.core.lang.NonNullApi;
import com.contrastsecurity.thirdparty.io.micrometer.core.lang.NonNullFields;
import com.contrastsecurity.thirdparty.io.micrometer.core.lang.Nullable;
import com.contrastsecurity.thirdparty.io.micrometer.core.util.internal.logging.InternalLogger;
import com.contrastsecurity.thirdparty.io.micrometer.core.util.internal.logging.InternalLoggerFactory;
import com.contrastsecurity.thirdparty.io.micrometer.core.util.internal.logging.WarnThenDebugLogger;
import com.contrastsecurity.thirdparty.org.apache.kafka.common.Metric;
import com.contrastsecurity.thirdparty.org.apache.kafka.common.MetricName;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import java.util.stream.Collectors;

@NonNullApi
@NonNullFields
@Incubating(since="1.4.0")
class KafkaMetrics
implements MeterBinder,
AutoCloseable {
    private static final InternalLogger log = InternalLoggerFactory.getInstance(KafkaMetrics.class);
    private static final WarnThenDebugLogger warnThenDebugLogger = new WarnThenDebugLogger(KafkaMetrics.class);
    static final String METRIC_NAME_PREFIX = "kafka.";
    static final String METRIC_GROUP_APP_INFO = "app-info";
    static final String METRIC_GROUP_METRICS_COUNT = "kafka-metrics-count";
    static final String VERSION_METRIC_NAME = "version";
    static final String START_TIME_METRIC_NAME = "start-time-ms";
    static final Duration DEFAULT_REFRESH_INTERVAL = Duration.ofSeconds(60L);
    static final String KAFKA_VERSION_TAG_NAME = "kafka.version";
    static final String DEFAULT_VALUE = "unknown";
    private final Supplier<Map<MetricName, ? extends Metric>> metricsSupplier;
    private final AtomicReference<Map<MetricName, ? extends Metric>> metrics = new AtomicReference();
    private final Iterable<Tag> extraTags;
    private final Duration refreshInterval;
    private final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor(new NamedThreadFactory("micrometer-kafka-metrics"));
    @Nullable
    private Iterable<Tag> commonTags;
    private volatile Set<MetricName> currentMeters = new HashSet<MetricName>();
    private String kafkaVersion = "unknown";
    @Nullable
    private volatile MeterRegistry registry;
    private final Set<Meter> registeredMeters = ConcurrentHashMap.newKeySet();

    KafkaMetrics(Supplier<Map<MetricName, ? extends Metric>> supplier) {
        this(supplier, Collections.emptyList());
    }

    KafkaMetrics(Supplier<Map<MetricName, ? extends Metric>> supplier, Iterable<Tag> iterable) {
        this(supplier, iterable, DEFAULT_REFRESH_INTERVAL);
    }

    KafkaMetrics(Supplier<Map<MetricName, ? extends Metric>> supplier, Iterable<Tag> iterable, Duration duration) {
        this.metricsSupplier = supplier;
        this.extraTags = iterable;
        this.refreshInterval = duration;
    }

    @Override
    public void bindTo(MeterRegistry meterRegistry) {
        this.registry = meterRegistry;
        this.commonTags = this.getCommonTags(meterRegistry);
        this.prepareToBindMetrics(meterRegistry);
        this.checkAndBindMetrics(meterRegistry);
        this.scheduler.scheduleAtFixedRate(() -> this.checkAndBindMetrics(meterRegistry), this.getRefreshIntervalInMillis(), this.getRefreshIntervalInMillis(), TimeUnit.MILLISECONDS);
    }

    private Iterable<Tag> getCommonTags(MeterRegistry meterRegistry) {
        Meter.Id id = Meter.builder("delete.this", Meter.Type.OTHER, Collections.emptyList()).register(meterRegistry).getId();
        meterRegistry.remove(id);
        return id.getTags();
    }

    void prepareToBindMetrics(MeterRegistry meterRegistry) {
        this.metrics.set(this.metricsSupplier.get());
        Map<MetricName, ? extends Metric> map = this.metrics.get();
        MetricName metricName = null;
        for (Map.Entry<MetricName, ? extends Metric> entry : map.entrySet()) {
            MetricName metricName2 = entry.getKey();
            if (!METRIC_GROUP_APP_INFO.equals(metricName2.group())) continue;
            if (VERSION_METRIC_NAME.equals(metricName2.name())) {
                this.kafkaVersion = (String)entry.getValue().metricValue();
                continue;
            }
            if (!START_TIME_METRIC_NAME.equals(metricName2.name())) continue;
            metricName = entry.getKey();
        }
        if (metricName != null) {
            this.bindMeter(meterRegistry, metricName, this.meterName(metricName), this.meterTags(metricName));
        }
    }

    private long getRefreshIntervalInMillis() {
        return this.refreshInterval.toMillis();
    }

    void checkAndBindMetrics(MeterRegistry meterRegistry) {
        try {
            Map<MetricName, ? extends Metric> map = this.metricsSupplier.get();
            this.metrics.set(map);
            if (!this.currentMeters.equals(map.keySet())) {
                Set set = this.currentMeters.stream().filter(metricName -> !map.containsKey(metricName)).collect(Collectors.toSet());
                for (MetricName metricName2 : set) {
                    Meter.Id id = this.meterIdForComparison(metricName2);
                    Meter meter2 = meterRegistry.remove(id);
                    if (meter2 == null) continue;
                    this.registeredMeters.remove(meter2);
                }
                this.currentMeters = new HashSet<MetricName>(map.keySet());
                Map<String, List<Meter>> map2 = meterRegistry.getMeters().stream().collect(Collectors.groupingBy(meter -> meter.getId().getName()));
                map.forEach((metricName, metric) -> {
                    Object object;
                    if (!(metric.metricValue() instanceof Number) || METRIC_GROUP_APP_INFO.equals(metricName.group()) || METRIC_GROUP_METRICS_COUNT.equals(metricName.group())) {
                        return;
                    }
                    String string2 = this.meterName((MetricName)metricName);
                    boolean bl = false;
                    for (Meter meter : map2.getOrDefault(string2, Collections.emptyList())) {
                        object = meter.getId().getTags();
                        List<Tag> list = this.meterTags((MetricName)metricName, true);
                        if (object.size() < list.size()) {
                            meterRegistry.remove(meter);
                            this.registeredMeters.remove(meter);
                            continue;
                        }
                        if (object.size() == list.size()) {
                            if (!object.containsAll(list)) break;
                            return;
                        }
                        bl = true;
                    }
                    if (bl) {
                        return;
                    }
                    List<Tag> list = this.meterTags((MetricName)metricName);
                    try {
                        Meter meter;
                        meter = this.bindMeter(meterRegistry, metric.metricName(), string2, (Iterable<Tag>)list);
                        object = map2.computeIfAbsent(string2, string -> new ArrayList());
                        object.add(meter);
                    }
                    catch (Exception exception) {
                        object = exception.getMessage();
                        if (object != null && ((String)object).contains("Prometheus requires")) {
                            warnThenDebugLogger.log("Failed to bind meter: " + string2 + " " + list + ". However, this could happen and might be restored in the next refresh.");
                        }
                        log.warn("Failed to bind meter: " + string2 + " " + list + ".", exception);
                    }
                });
            }
        }
        catch (Exception exception) {
            log.warn("Failed to bind KafkaMetric", exception);
        }
    }

    private Meter bindMeter(MeterRegistry meterRegistry, MetricName metricName, String string, Iterable<Tag> iterable) {
        Meter meter = this.registerMeter(meterRegistry, metricName, string, iterable);
        this.registeredMeters.add(meter);
        return meter;
    }

    private Meter registerMeter(MeterRegistry meterRegistry, MetricName metricName, String string, Iterable<Tag> iterable) {
        if (string.endsWith("total") || string.endsWith("count")) {
            return this.registerCounter(meterRegistry, metricName, string, iterable);
        }
        return this.registerGauge(meterRegistry, metricName, string, iterable);
    }

    private Gauge registerGauge(MeterRegistry meterRegistry, MetricName metricName, String string, Iterable<Tag> iterable) {
        return Gauge.builder(string, this.metrics, this.toMetricValue(metricName)).tags(iterable).description(metricName.description()).register(meterRegistry);
    }

    private FunctionCounter registerCounter(MeterRegistry meterRegistry, MetricName metricName, String string, Iterable<Tag> iterable) {
        return FunctionCounter.builder(string, this.metrics, this.toMetricValue(metricName)).tags(iterable).description(metricName.description()).register(meterRegistry);
    }

    private ToDoubleFunction<AtomicReference<Map<MetricName, ? extends Metric>>> toMetricValue(MetricName metricName) {
        return atomicReference -> this.toDouble((Metric)((Map)atomicReference.get()).get(metricName));
    }

    private double toDouble(@Nullable Metric metric) {
        return metric != null ? ((Number)metric.metricValue()).doubleValue() : Double.NaN;
    }

    private List<Tag> meterTags(MetricName metricName, boolean bl) {
        ArrayList<Tag> arrayList = new ArrayList<Tag>();
        metricName.tags().forEach((string, string2) -> arrayList.add(Tag.of(string.replaceAll("-", "."), string2)));
        arrayList.add(Tag.of(KAFKA_VERSION_TAG_NAME, this.kafkaVersion));
        this.extraTags.forEach(arrayList::add);
        if (bl) {
            this.commonTags.forEach(arrayList::add);
        }
        return arrayList;
    }

    private List<Tag> meterTags(MetricName metricName) {
        return this.meterTags(metricName, false);
    }

    private String meterName(MetricName metricName) {
        String string = METRIC_NAME_PREFIX + metricName.group() + "." + metricName.name();
        return string.replaceAll("-metrics", "").replaceAll("-", ".");
    }

    private Meter.Id meterIdForComparison(MetricName metricName) {
        return new Meter.Id(this.meterName(metricName), Tags.of(this.meterTags(metricName, true)), null, null, Meter.Type.OTHER);
    }

    @Override
    public void close() {
        this.scheduler.shutdownNow();
        for (Meter meter : this.registeredMeters) {
            this.registry.remove(meter);
        }
    }
}

