/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.micrometer.core.instrument.binder.logging;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.turbo.TurboFilter;
import ch.qos.logback.core.spi.FilterReply;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Counter;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.MeterRegistry;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Tag;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.binder.logging.LogbackMetrics;
import com.contrastsecurity.thirdparty.io.micrometer.core.lang.NonNullApi;
import com.contrastsecurity.thirdparty.io.micrometer.core.lang.NonNullFields;
import com.contrastsecurity.thirdparty.org.slf4j.Marker;

@NonNullApi
@NonNullFields
class MetricsTurboFilter
extends TurboFilter {
    private final Counter errorCounter;
    private final Counter warnCounter;
    private final Counter infoCounter;
    private final Counter debugCounter;
    private final Counter traceCounter;

    MetricsTurboFilter(MeterRegistry meterRegistry, Iterable<Tag> iterable) {
        this.errorCounter = Counter.builder("logback.events").tags(iterable).tags("level", "error").description("Number of error level events that made it to the logs").baseUnit("events").register(meterRegistry);
        this.warnCounter = Counter.builder("logback.events").tags(iterable).tags("level", "warn").description("Number of warn level events that made it to the logs").baseUnit("events").register(meterRegistry);
        this.infoCounter = Counter.builder("logback.events").tags(iterable).tags("level", "info").description("Number of info level events that made it to the logs").baseUnit("events").register(meterRegistry);
        this.debugCounter = Counter.builder("logback.events").tags(iterable).tags("level", "debug").description("Number of debug level events that made it to the logs").baseUnit("events").register(meterRegistry);
        this.traceCounter = Counter.builder("logback.events").tags(iterable).tags("level", "trace").description("Number of trace level events that made it to the logs").baseUnit("events").register(meterRegistry);
    }

    public FilterReply decide(Marker marker, Logger logger, Level level, String string, Object[] objectArray, Throwable throwable) {
        if (string == null) {
            return FilterReply.NEUTRAL;
        }
        Boolean bl = LogbackMetrics.ignoreMetrics.get();
        if (bl != null && bl.booleanValue()) {
            return FilterReply.NEUTRAL;
        }
        if (level.isGreaterOrEqual(logger.getEffectiveLevel())) {
            switch (level.toInt()) {
                case 40000: {
                    this.errorCounter.increment();
                    break;
                }
                case 30000: {
                    this.warnCounter.increment();
                    break;
                }
                case 20000: {
                    this.infoCounter.increment();
                    break;
                }
                case 10000: {
                    this.debugCounter.increment();
                    break;
                }
                case 5000: {
                    this.traceCounter.increment();
                }
            }
        }
        return FilterReply.NEUTRAL;
    }
}

