/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.micrometer.core.instrument.binder.mongodb;

import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Tag;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Tags;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.binder.mongodb.MongoCommandTagsProvider;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.util.StringUtils;
import com.contrastsecurity.thirdparty.io.micrometer.core.util.internal.logging.WarnThenDebugLogger;
import com.mongodb.event.CommandEvent;
import com.mongodb.event.CommandStartedEvent;
import com.mongodb.event.CommandSucceededEvent;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.bson.BsonDocument;
import org.bson.BsonString;
import org.bson.BsonValue;

public class DefaultMongoCommandTagsProvider
implements MongoCommandTagsProvider {
    private static final Set<String> COMMANDS_WITH_COLLECTION_NAME = new HashSet<String>(Arrays.asList("aggregate", "count", "distinct", "mapReduce", "geoSearch", "delete", "find", "findAndModify", "insert", "update", "collMod", "compact", "convertToCapped", "create", "createIndexes", "drop", "dropIndexes", "killCursors", "listIndexes", "reIndex"));
    private static final WarnThenDebugLogger WARN_THEN_DEBUG_LOGGER = new WarnThenDebugLogger(DefaultMongoCommandTagsProvider.class);
    private final ConcurrentMap<Integer, String> inFlightCommandCollectionNames = new ConcurrentHashMap<Integer, String>();

    @Override
    public Iterable<Tag> commandTags(CommandEvent commandEvent) {
        return Tags.of(Tag.of("command", commandEvent.getCommandName()), Tag.of("collection", this.getAndRemoveCollectionNameForCommand(commandEvent)), Tag.of("cluster.id", commandEvent.getConnectionDescription().getConnectionId().getServerId().getClusterId().getValue()), Tag.of("server.address", commandEvent.getConnectionDescription().getServerAddress().toString()), Tag.of("status", commandEvent instanceof CommandSucceededEvent ? "SUCCESS" : "FAILED"));
    }

    @Override
    public void commandStarted(CommandStartedEvent commandStartedEvent) {
        this.determineCollectionName(commandStartedEvent.getCommandName(), commandStartedEvent.getCommand()).ifPresent(string -> this.addCollectionNameForCommand((CommandEvent)commandStartedEvent, (String)string));
    }

    private void addCollectionNameForCommand(CommandEvent commandEvent, String string) {
        if (this.inFlightCommandCollectionNames.size() < 1000) {
            this.inFlightCommandCollectionNames.put(commandEvent.getRequestId(), string);
            return;
        }
        WARN_THEN_DEBUG_LOGGER.log("Collection names cache is full - Mongo is not calling listeners properly");
    }

    private String getAndRemoveCollectionNameForCommand(CommandEvent commandEvent) {
        String string = (String)this.inFlightCommandCollectionNames.remove(commandEvent.getRequestId());
        return string != null ? string : "unknown";
    }

    protected Optional<String> determineCollectionName(String string, BsonDocument bsonDocument) {
        Optional<String> optional;
        if (COMMANDS_WITH_COLLECTION_NAME.contains(string) && (optional = this.getNonEmptyBsonString(bsonDocument.get((Object)string))).isPresent()) {
            return optional;
        }
        return this.getNonEmptyBsonString(bsonDocument.get((Object)"collection"));
    }

    private Optional<String> getNonEmptyBsonString(BsonValue bsonValue) {
        return Optional.ofNullable(bsonValue).filter(BsonValue::isString).map(BsonValue::asString).map(BsonString::getValue).map(String::trim).filter(StringUtils::isNotEmpty);
    }
}

