/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.micrometer.core.instrument.binder.mongodb;

import com.contrastsecurity.thirdparty.io.micrometer.core.annotation.Incubating;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.MeterRegistry;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Timer;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.binder.mongodb.DefaultMongoCommandTagsProvider;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.binder.mongodb.MongoCommandTagsProvider;
import com.contrastsecurity.thirdparty.io.micrometer.core.lang.NonNullApi;
import com.contrastsecurity.thirdparty.io.micrometer.core.lang.NonNullFields;
import com.mongodb.event.CommandEvent;
import com.mongodb.event.CommandFailedEvent;
import com.mongodb.event.CommandListener;
import com.mongodb.event.CommandStartedEvent;
import com.mongodb.event.CommandSucceededEvent;
import java.util.concurrent.TimeUnit;

@NonNullApi
@NonNullFields
@Incubating(since="1.2.0")
public class MongoMetricsCommandListener
implements CommandListener {
    private final MeterRegistry registry;
    private final MongoCommandTagsProvider tagsProvider;

    public MongoMetricsCommandListener(MeterRegistry meterRegistry) {
        this(meterRegistry, new DefaultMongoCommandTagsProvider());
    }

    public MongoMetricsCommandListener(MeterRegistry meterRegistry, MongoCommandTagsProvider mongoCommandTagsProvider) {
        this.registry = meterRegistry;
        this.tagsProvider = mongoCommandTagsProvider;
    }

    public void commandStarted(CommandStartedEvent commandStartedEvent) {
        this.tagsProvider.commandStarted(commandStartedEvent);
    }

    public void commandSucceeded(CommandSucceededEvent commandSucceededEvent) {
        this.timeCommand((CommandEvent)commandSucceededEvent, commandSucceededEvent.getElapsedTime(TimeUnit.NANOSECONDS));
    }

    public void commandFailed(CommandFailedEvent commandFailedEvent) {
        this.timeCommand((CommandEvent)commandFailedEvent, commandFailedEvent.getElapsedTime(TimeUnit.NANOSECONDS));
    }

    private void timeCommand(CommandEvent commandEvent, long l2) {
        ((Timer.Builder)Timer.builder("mongodb.driver.commands").description("Timer of mongodb commands").tags((Iterable)this.tagsProvider.commandTags(commandEvent))).register(this.registry).record(l2, TimeUnit.NANOSECONDS);
    }
}

