/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.micrometer.core.instrument.binder.mongodb;

import com.contrastsecurity.thirdparty.io.micrometer.core.annotation.Incubating;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Gauge;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Meter;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.MeterRegistry;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.binder.mongodb.DefaultMongoConnectionPoolTagsProvider;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.binder.mongodb.MongoConnectionPoolTagsProvider;
import com.contrastsecurity.thirdparty.io.micrometer.core.lang.NonNullApi;
import com.contrastsecurity.thirdparty.io.micrometer.core.lang.NonNullFields;
import com.mongodb.connection.ServerId;
import com.mongodb.event.ConnectionCheckOutFailedEvent;
import com.mongodb.event.ConnectionCheckOutStartedEvent;
import com.mongodb.event.ConnectionCheckedInEvent;
import com.mongodb.event.ConnectionCheckedOutEvent;
import com.mongodb.event.ConnectionClosedEvent;
import com.mongodb.event.ConnectionCreatedEvent;
import com.mongodb.event.ConnectionPoolClosedEvent;
import com.mongodb.event.ConnectionPoolCreatedEvent;
import com.mongodb.event.ConnectionPoolListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

@NonNullApi
@NonNullFields
@Incubating(since="1.2.0")
public class MongoMetricsConnectionPoolListener
implements ConnectionPoolListener {
    private static final String METRIC_PREFIX = "mongodb.driver.pool.";
    private final Map<ServerId, AtomicInteger> poolSizes = new ConcurrentHashMap<ServerId, AtomicInteger>();
    private final Map<ServerId, AtomicInteger> checkedOutCounts = new ConcurrentHashMap<ServerId, AtomicInteger>();
    private final Map<ServerId, AtomicInteger> waitQueueSizes = new ConcurrentHashMap<ServerId, AtomicInteger>();
    private final Map<ServerId, List<Meter>> meters = new ConcurrentHashMap<ServerId, List<Meter>>();
    private final MeterRegistry registry;
    private final MongoConnectionPoolTagsProvider tagsProvider;

    public MongoMetricsConnectionPoolListener(MeterRegistry meterRegistry) {
        this(meterRegistry, new DefaultMongoConnectionPoolTagsProvider());
    }

    public MongoMetricsConnectionPoolListener(MeterRegistry meterRegistry, MongoConnectionPoolTagsProvider mongoConnectionPoolTagsProvider) {
        this.registry = meterRegistry;
        this.tagsProvider = mongoConnectionPoolTagsProvider;
    }

    public void connectionPoolCreated(ConnectionPoolCreatedEvent connectionPoolCreatedEvent) {
        ArrayList<Gauge> arrayList = new ArrayList<Gauge>();
        arrayList.add(this.registerGauge(connectionPoolCreatedEvent, "mongodb.driver.pool.size", "the current size of the connection pool, including idle and and in-use members", this.poolSizes));
        arrayList.add(this.registerGauge(connectionPoolCreatedEvent, "mongodb.driver.pool.checkedout", "the count of connections that are currently in use", this.checkedOutCounts));
        arrayList.add(this.registerGauge(connectionPoolCreatedEvent, "mongodb.driver.pool.waitqueuesize", "the current size of the wait queue for a connection from the pool", this.waitQueueSizes));
        this.meters.put(connectionPoolCreatedEvent.getServerId(), arrayList);
    }

    public void connectionPoolClosed(ConnectionPoolClosedEvent connectionPoolClosedEvent) {
        ServerId serverId = connectionPoolClosedEvent.getServerId();
        for (Meter meter : this.meters.get(serverId)) {
            this.registry.remove(meter);
        }
        this.meters.remove(serverId);
        this.poolSizes.remove(serverId);
        this.checkedOutCounts.remove(serverId);
        this.waitQueueSizes.remove(serverId);
    }

    public void connectionCheckOutStarted(ConnectionCheckOutStartedEvent connectionCheckOutStartedEvent) {
        AtomicInteger atomicInteger = this.waitQueueSizes.get(connectionCheckOutStartedEvent.getServerId());
        if (atomicInteger != null) {
            atomicInteger.incrementAndGet();
        }
    }

    public void connectionCheckedOut(ConnectionCheckedOutEvent connectionCheckedOutEvent) {
        AtomicInteger atomicInteger;
        AtomicInteger atomicInteger2 = this.checkedOutCounts.get(connectionCheckedOutEvent.getConnectionId().getServerId());
        if (atomicInteger2 != null) {
            atomicInteger2.incrementAndGet();
        }
        if ((atomicInteger = this.waitQueueSizes.get(connectionCheckedOutEvent.getConnectionId().getServerId())) != null) {
            atomicInteger.decrementAndGet();
        }
    }

    public void connectionCheckOutFailed(ConnectionCheckOutFailedEvent connectionCheckOutFailedEvent) {
        AtomicInteger atomicInteger = this.waitQueueSizes.get(connectionCheckOutFailedEvent.getServerId());
        if (atomicInteger != null) {
            atomicInteger.decrementAndGet();
        }
    }

    public void connectionCheckedIn(ConnectionCheckedInEvent connectionCheckedInEvent) {
        AtomicInteger atomicInteger = this.checkedOutCounts.get(connectionCheckedInEvent.getConnectionId().getServerId());
        if (atomicInteger != null) {
            atomicInteger.decrementAndGet();
        }
    }

    public void connectionCreated(ConnectionCreatedEvent connectionCreatedEvent) {
        AtomicInteger atomicInteger = this.poolSizes.get(connectionCreatedEvent.getConnectionId().getServerId());
        if (atomicInteger != null) {
            atomicInteger.incrementAndGet();
        }
    }

    public void connectionClosed(ConnectionClosedEvent connectionClosedEvent) {
        AtomicInteger atomicInteger = this.poolSizes.get(connectionClosedEvent.getConnectionId().getServerId());
        if (atomicInteger != null) {
            atomicInteger.decrementAndGet();
        }
    }

    private Gauge registerGauge(ConnectionPoolCreatedEvent connectionPoolCreatedEvent, String string, String string2, Map<ServerId, AtomicInteger> map) {
        AtomicInteger atomicInteger = new AtomicInteger();
        map.put(connectionPoolCreatedEvent.getServerId(), atomicInteger);
        return Gauge.builder(string, atomicInteger, AtomicInteger::doubleValue).description(string2).tags(this.tagsProvider.connectionPoolTags(connectionPoolCreatedEvent)).register(this.registry);
    }
}

