/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.micrometer.core.instrument.binder.okhttp3;

import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Gauge;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.MeterRegistry;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Tag;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Tags;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.binder.MeterBinder;
import com.contrastsecurity.thirdparty.io.micrometer.core.lang.NonNull;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import okhttp3.ConnectionPool;

public class OkHttpConnectionPoolMetrics
implements MeterBinder {
    private static final String DEFAULT_NAME_PREFIX = "okhttp.pool";
    private static final String TAG_STATE = "state";
    private final ConnectionPool connectionPool;
    private final String namePrefix;
    private final Iterable<Tag> tags;
    private final Double maxIdleConnectionCount;
    private final ThreadLocal<ConnectionPoolConnectionStats> connectionStats = new ThreadLocal();

    public OkHttpConnectionPoolMetrics(ConnectionPool connectionPool) {
        this(connectionPool, DEFAULT_NAME_PREFIX, Collections.emptyList(), null);
    }

    public OkHttpConnectionPoolMetrics(ConnectionPool connectionPool, Iterable<Tag> iterable) {
        this(connectionPool, DEFAULT_NAME_PREFIX, iterable, null);
    }

    public OkHttpConnectionPoolMetrics(ConnectionPool connectionPool, String string, Iterable<Tag> iterable) {
        this(connectionPool, string, iterable, null);
    }

    public OkHttpConnectionPoolMetrics(ConnectionPool connectionPool, String string, Iterable<Tag> iterable, Integer n2) {
        if (connectionPool == null) {
            throw new IllegalArgumentException("Given ConnectionPool must not be null.");
        }
        if (string == null) {
            throw new IllegalArgumentException("Given name prefix must not be null.");
        }
        if (iterable == null) {
            throw new IllegalArgumentException("Given list of tags must not be null.");
        }
        this.connectionPool = connectionPool;
        this.namePrefix = string;
        this.tags = iterable;
        this.maxIdleConnectionCount = Optional.ofNullable(n2).map(Integer::doubleValue).orElse(null);
    }

    @Override
    public void bindTo(@NonNull MeterRegistry meterRegistry) {
        String string = this.namePrefix + ".connection.count";
        Gauge.builder(string, this.connectionStats, threadLocal -> {
            if (threadLocal.get() == null) {
                threadLocal.set(new ConnectionPoolConnectionStats());
            }
            return ((ConnectionPoolConnectionStats)threadLocal.get()).getActiveCount();
        }).baseUnit("connections").description("The state of connections in the OkHttp connection pool").tags(Tags.of(this.tags).and(TAG_STATE, "active")).register(meterRegistry);
        Gauge.builder(string, this.connectionStats, threadLocal -> {
            if (threadLocal.get() == null) {
                threadLocal.set(new ConnectionPoolConnectionStats());
            }
            return ((ConnectionPoolConnectionStats)threadLocal.get()).getIdleConnectionCount();
        }).baseUnit("connections").description("The state of connections in the OkHttp connection pool").tags(Tags.of(this.tags).and(TAG_STATE, "idle")).register(meterRegistry);
        if (this.maxIdleConnectionCount != null) {
            Gauge.builder(this.namePrefix + ".connection.limit", () -> this.maxIdleConnectionCount).baseUnit("connections").description("The maximum idle connection count in an OkHttp connection pool.").tags(Tags.concat(this.tags, new String[0])).register(meterRegistry);
        }
    }

    private final class ConnectionPoolConnectionStats {
        private CountDownLatch uses = new CountDownLatch(0);
        private int idle;
        private int total;

        private ConnectionPoolConnectionStats() {
        }

        public int getActiveCount() {
            this.snapshotStatsIfNecessary();
            this.uses.countDown();
            return this.total - this.idle;
        }

        public int getIdleConnectionCount() {
            this.snapshotStatsIfNecessary();
            this.uses.countDown();
            return this.idle;
        }

        private void snapshotStatsIfNecessary() {
            if (this.uses.getCount() == 0L) {
                this.idle = OkHttpConnectionPoolMetrics.this.connectionPool.idleConnectionCount();
                this.total = OkHttpConnectionPoolMetrics.this.connectionPool.connectionCount();
                this.uses = new CountDownLatch(2);
            }
        }
    }
}

