/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.micrometer.core.instrument.binder.tomcat;

import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.FunctionCounter;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.FunctionTimer;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Gauge;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.MeterRegistry;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Tag;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Tags;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.TimeGauge;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.binder.MeterBinder;
import com.contrastsecurity.thirdparty.io.micrometer.core.lang.NonNullApi;
import com.contrastsecurity.thirdparty.io.micrometer.core.lang.NonNullFields;
import com.contrastsecurity.thirdparty.io.micrometer.core.lang.Nullable;
import com.contrastsecurity.thirdparty.org.apache.catalina.Manager;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import javax.management.InstanceNotFoundException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanServer;
import javax.management.MBeanServerDelegate;
import javax.management.MBeanServerFactory;
import javax.management.MBeanServerNotification;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;

@NonNullApi
@NonNullFields
public class TomcatMetrics
implements MeterBinder,
AutoCloseable {
    private static final String JMX_DOMAIN_EMBEDDED = "Tomcat";
    private static final String JMX_DOMAIN_STANDALONE = "Catalina";
    private static final String OBJECT_NAME_SERVER_SUFFIX = ":type=Server";
    private static final String OBJECT_NAME_SERVER_EMBEDDED = "Tomcat:type=Server";
    private static final String OBJECT_NAME_SERVER_STANDALONE = "Catalina:type=Server";
    @Nullable
    private final Manager manager;
    private final MBeanServer mBeanServer;
    private final Iterable<Tag> tags;
    private final Set<NotificationListener> notificationListeners = ConcurrentHashMap.newKeySet();
    private volatile String jmxDomain;

    public TomcatMetrics(@Nullable Manager manager, Iterable<Tag> iterable) {
        this(manager, iterable, TomcatMetrics.getMBeanServer());
    }

    public TomcatMetrics(@Nullable Manager manager, Iterable<Tag> iterable, MBeanServer mBeanServer) {
        this.manager = manager;
        this.tags = iterable;
        this.mBeanServer = mBeanServer;
        if (manager != null) {
            this.jmxDomain = manager.getContext().getDomain();
        }
    }

    public static void monitor(MeterRegistry meterRegistry, @Nullable Manager manager, String ... stringArray) {
        TomcatMetrics.monitor(meterRegistry, manager, Tags.of(stringArray));
    }

    public static void monitor(MeterRegistry meterRegistry, @Nullable Manager manager, Iterable<Tag> iterable) {
        new TomcatMetrics(manager, iterable).bindTo(meterRegistry);
    }

    public static MBeanServer getMBeanServer() {
        ArrayList<MBeanServer> arrayList = MBeanServerFactory.findMBeanServer(null);
        if (!arrayList.isEmpty()) {
            return (MBeanServer)arrayList.get(0);
        }
        return ManagementFactory.getPlatformMBeanServer();
    }

    @Override
    public void bindTo(MeterRegistry meterRegistry) {
        this.registerGlobalRequestMetrics(meterRegistry);
        this.registerServletMetrics(meterRegistry);
        this.registerCacheMetrics(meterRegistry);
        this.registerThreadPoolMetrics(meterRegistry);
        this.registerSessionMetrics(meterRegistry);
    }

    private void registerSessionMetrics(MeterRegistry meterRegistry) {
        if (this.manager == null) {
            return;
        }
        Gauge.builder("tomcat.sessions.active.max", this.manager, Manager::getMaxActive).tags(this.tags).baseUnit("sessions").register(meterRegistry);
        Gauge.builder("tomcat.sessions.active.current", this.manager, Manager::getActiveSessions).tags(this.tags).baseUnit("sessions").register(meterRegistry);
        FunctionCounter.builder("tomcat.sessions.created", this.manager, Manager::getSessionCounter).tags(this.tags).baseUnit("sessions").register(meterRegistry);
        FunctionCounter.builder("tomcat.sessions.expired", this.manager, Manager::getExpiredSessions).tags(this.tags).baseUnit("sessions").register(meterRegistry);
        FunctionCounter.builder("tomcat.sessions.rejected", this.manager, Manager::getRejectedSessions).tags(this.tags).baseUnit("sessions").register(meterRegistry);
        TimeGauge.builder("tomcat.sessions.alive.max", this.manager, TimeUnit.SECONDS, Manager::getSessionMaxAliveTime).tags(this.tags).register(meterRegistry);
    }

    private void registerThreadPoolMetrics(MeterRegistry meterRegistry) {
        this.registerMetricsEventually(":type=ThreadPool,name=*", (objectName, iterable) -> {
            Gauge.builder("tomcat.threads.config.max", this.mBeanServer, mBeanServer -> this.safeDouble(() -> mBeanServer.getAttribute((ObjectName)objectName, "maxThreads"))).tags((Iterable<Tag>)iterable).baseUnit("threads").register(meterRegistry);
            Gauge.builder("tomcat.threads.busy", this.mBeanServer, mBeanServer -> this.safeDouble(() -> mBeanServer.getAttribute((ObjectName)objectName, "currentThreadsBusy"))).tags((Iterable<Tag>)iterable).baseUnit("threads").register(meterRegistry);
            Gauge.builder("tomcat.threads.current", this.mBeanServer, mBeanServer -> this.safeDouble(() -> mBeanServer.getAttribute((ObjectName)objectName, "currentThreadCount"))).tags((Iterable<Tag>)iterable).baseUnit("threads").register(meterRegistry);
            Gauge.builder("tomcat.connections.current", this.mBeanServer, mBeanServer -> this.safeDouble(() -> mBeanServer.getAttribute((ObjectName)objectName, "connectionCount"))).tags((Iterable<Tag>)iterable).baseUnit("connections").register(meterRegistry);
            Gauge.builder("tomcat.connections.keepalive.current", this.mBeanServer, mBeanServer -> this.safeDouble(() -> mBeanServer.getAttribute((ObjectName)objectName, "keepAliveCount"))).tags((Iterable<Tag>)iterable).baseUnit("connections").register(meterRegistry);
            Gauge.builder("tomcat.connections.config.max", this.mBeanServer, mBeanServer -> this.safeDouble(() -> mBeanServer.getAttribute((ObjectName)objectName, "maxConnections"))).tags((Iterable<Tag>)iterable).baseUnit("connections").register(meterRegistry);
        });
    }

    private void registerCacheMetrics(MeterRegistry meterRegistry) {
        this.registerMetricsEventually(":type=StringCache", (objectName, iterable) -> {
            FunctionCounter.builder("tomcat.cache.access", this.mBeanServer, mBeanServer -> this.safeDouble(() -> mBeanServer.getAttribute((ObjectName)objectName, "accessCount"))).tags((Iterable<Tag>)iterable).register(meterRegistry);
            FunctionCounter.builder("tomcat.cache.hit", this.mBeanServer, mBeanServer -> this.safeDouble(() -> mBeanServer.getAttribute((ObjectName)objectName, "hitCount"))).tags((Iterable<Tag>)iterable).register(meterRegistry);
        });
    }

    private void registerServletMetrics(MeterRegistry meterRegistry) {
        this.registerMetricsEventually(":j2eeType=Servlet,name=*,*", (objectName, iterable) -> {
            FunctionCounter.builder("tomcat.servlet.error", this.mBeanServer, mBeanServer -> this.safeDouble(() -> mBeanServer.getAttribute((ObjectName)objectName, "errorCount"))).tags((Iterable<Tag>)iterable).register(meterRegistry);
            FunctionTimer.builder("tomcat.servlet.request", this.mBeanServer, mBeanServer -> this.safeLong(() -> mBeanServer.getAttribute((ObjectName)objectName, "requestCount")), mBeanServer -> this.safeDouble(() -> mBeanServer.getAttribute((ObjectName)objectName, "processingTime")), TimeUnit.MILLISECONDS).tags((Iterable<Tag>)iterable).register(meterRegistry);
            TimeGauge.builder("tomcat.servlet.request.max", this.mBeanServer, TimeUnit.MILLISECONDS, mBeanServer -> this.safeDouble(() -> mBeanServer.getAttribute((ObjectName)objectName, "maxTime"))).tags((Iterable<Tag>)iterable).register(meterRegistry);
        });
    }

    private void registerGlobalRequestMetrics(MeterRegistry meterRegistry) {
        this.registerMetricsEventually(":type=GlobalRequestProcessor,name=*", (objectName, iterable) -> {
            FunctionCounter.builder("tomcat.global.sent", this.mBeanServer, mBeanServer -> this.safeDouble(() -> mBeanServer.getAttribute((ObjectName)objectName, "bytesSent"))).tags((Iterable<Tag>)iterable).baseUnit("bytes").register(meterRegistry);
            FunctionCounter.builder("tomcat.global.received", this.mBeanServer, mBeanServer -> this.safeDouble(() -> mBeanServer.getAttribute((ObjectName)objectName, "bytesReceived"))).tags((Iterable<Tag>)iterable).baseUnit("bytes").register(meterRegistry);
            FunctionCounter.builder("tomcat.global.error", this.mBeanServer, mBeanServer -> this.safeDouble(() -> mBeanServer.getAttribute((ObjectName)objectName, "errorCount"))).tags((Iterable<Tag>)iterable).register(meterRegistry);
            FunctionTimer.builder("tomcat.global.request", this.mBeanServer, mBeanServer -> this.safeLong(() -> mBeanServer.getAttribute((ObjectName)objectName, "requestCount")), mBeanServer -> this.safeDouble(() -> mBeanServer.getAttribute((ObjectName)objectName, "processingTime")), TimeUnit.MILLISECONDS).tags((Iterable<Tag>)iterable).register(meterRegistry);
            TimeGauge.builder("tomcat.global.request.max", this.mBeanServer, TimeUnit.MILLISECONDS, mBeanServer -> this.safeDouble(() -> mBeanServer.getAttribute((ObjectName)objectName, "maxTime"))).tags((Iterable<Tag>)iterable).register(meterRegistry);
        });
    }

    private void registerMetricsEventually(final String string, final BiConsumer<ObjectName, Iterable<Tag>> biConsumer) {
        Object object;
        if (this.getJmxDomain() != null && !(object = this.mBeanServer.queryNames(this.getNamePattern(string), null)).isEmpty()) {
            object.forEach(objectName -> biConsumer.accept((ObjectName)objectName, Tags.concat(this.tags, this.nameTag((ObjectName)objectName))));
            return;
        }
        object = new NotificationListener(){

            @Override
            public void handleNotification(Notification notification, Object object) {
                MBeanServerNotification mBeanServerNotification = (MBeanServerNotification)notification;
                ObjectName objectName = mBeanServerNotification.getMBeanName();
                biConsumer.accept(objectName, Tags.concat((Iterable<? extends Tag>)TomcatMetrics.this.tags, TomcatMetrics.this.nameTag(objectName)));
                if (TomcatMetrics.this.getNamePattern(string).isPattern()) {
                    return;
                }
                try {
                    TomcatMetrics.this.mBeanServer.removeNotificationListener(MBeanServerDelegate.DELEGATE_NAME, this);
                    TomcatMetrics.this.notificationListeners.remove(this);
                }
                catch (InstanceNotFoundException | ListenerNotFoundException operationsException) {
                    throw new RuntimeException(operationsException);
                }
            }
        };
        this.notificationListeners.add((NotificationListener)object);
        NotificationFilter notificationFilter = notification -> {
            if (!"JMX.mbean.registered".equals(notification.getType())) {
                return false;
            }
            ObjectName objectName = ((MBeanServerNotification)notification).getMBeanName();
            return this.getNamePattern(string).apply(objectName);
        };
        try {
            this.mBeanServer.addNotificationListener(MBeanServerDelegate.DELEGATE_NAME, (NotificationListener)object, notificationFilter, null);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw new RuntimeException("Error registering MBean listener", instanceNotFoundException);
        }
    }

    private ObjectName getNamePattern(String string) {
        try {
            return new ObjectName(this.getJmxDomain() + string);
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            throw new RuntimeException("Error registering Tomcat JMX based metrics", malformedObjectNameException);
        }
    }

    private String getJmxDomain() {
        if (this.jmxDomain == null) {
            if (this.hasObjectName(OBJECT_NAME_SERVER_EMBEDDED)) {
                this.jmxDomain = JMX_DOMAIN_EMBEDDED;
            } else if (this.hasObjectName(OBJECT_NAME_SERVER_STANDALONE)) {
                this.jmxDomain = JMX_DOMAIN_STANDALONE;
            }
        }
        return this.jmxDomain;
    }

    public void setJmxDomain(String string) {
        this.jmxDomain = string;
    }

    private boolean hasObjectName(String string) {
        try {
            return this.mBeanServer.queryNames(new ObjectName(string), null).size() == 1;
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            throw new RuntimeException(malformedObjectNameException);
        }
    }

    private double safeDouble(Callable<Object> callable) {
        try {
            return Double.parseDouble(callable.call().toString());
        }
        catch (Exception exception) {
            return Double.NaN;
        }
    }

    private long safeLong(Callable<Object> callable) {
        try {
            return Long.parseLong(callable.call().toString());
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    private Iterable<Tag> nameTag(ObjectName objectName) {
        String string = objectName.getKeyProperty("name");
        if (string != null) {
            return Tags.of("name", string.replaceAll("\"", ""));
        }
        return Collections.emptyList();
    }

    @Override
    public void close() {
        for (NotificationListener notificationListener : this.notificationListeners) {
            try {
                this.mBeanServer.removeNotificationListener(MBeanServerDelegate.DELEGATE_NAME, notificationListener);
            }
            catch (InstanceNotFoundException | ListenerNotFoundException operationsException) {
                throw new RuntimeException(operationsException);
            }
        }
    }
}

