/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.micrometer.core.instrument.composite;

import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.AbstractMeter;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Meter;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.MeterRegistry;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.composite.CompositeMeter;
import com.contrastsecurity.thirdparty.io.micrometer.core.lang.Nullable;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;

abstract class AbstractCompositeMeter<T extends Meter>
extends AbstractMeter
implements CompositeMeter {
    private AtomicBoolean childrenGuard = new AtomicBoolean();
    private Map<MeterRegistry, T> children = Collections.emptyMap();
    @Nullable
    private volatile T noopMeter;

    AbstractCompositeMeter(Meter.Id id) {
        super(id);
    }

    abstract T newNoopMeter();

    @Nullable
    abstract T registerNewMeter(MeterRegistry var1);

    final void forEachChild(Consumer<T> consumer) {
        this.children.values().forEach(consumer);
    }

    T firstChild() {
        Iterator<T> iterator = this.children.values().iterator();
        if (iterator.hasNext()) {
            return (T)((Meter)iterator.next());
        }
        T t2 = this.noopMeter;
        if (t2 != null) {
            return t2;
        }
        this.noopMeter = this.newNoopMeter();
        return this.noopMeter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void add(MeterRegistry meterRegistry) {
        T t2 = this.registerNewMeter(meterRegistry);
        if (t2 == null) {
            return;
        }
        while (!this.childrenGuard.compareAndSet(false, true)) {
        }
        try {
            IdentityHashMap<MeterRegistry, T> identityHashMap = new IdentityHashMap<MeterRegistry, T>(this.children);
            identityHashMap.put(meterRegistry, t2);
            this.children = identityHashMap;
        }
        finally {
            this.childrenGuard.set(false);
        }
    }

    @Override
    @Deprecated
    public final void remove(MeterRegistry meterRegistry) {
        while (!this.childrenGuard.compareAndSet(false, true)) {
        }
        try {
            IdentityHashMap<MeterRegistry, T> identityHashMap = new IdentityHashMap<MeterRegistry, T>(this.children);
            identityHashMap.remove(meterRegistry);
            this.children = identityHashMap;
        }
        finally {
            this.childrenGuard.set(false);
        }
    }
}

