/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.micrometer.core.instrument.composite;

import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.LongTaskTimer;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Meter;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.MeterRegistry;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.composite.AbstractCompositeMeter;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.distribution.HistogramSnapshot;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.noop.NoopLongTaskTimer;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

class CompositeLongTaskTimer
extends AbstractCompositeMeter<LongTaskTimer>
implements LongTaskTimer {
    private final DistributionStatisticConfig distributionStatisticConfig;

    CompositeLongTaskTimer(Meter.Id id, DistributionStatisticConfig distributionStatisticConfig) {
        super(id);
        this.distributionStatisticConfig = distributionStatisticConfig;
    }

    @Override
    public LongTaskTimer.Sample start() {
        ArrayList arrayList = new ArrayList();
        this.forEachChild(longTaskTimer -> arrayList.add(longTaskTimer.start()));
        return new CompositeSample(arrayList);
    }

    @Override
    public double duration(TimeUnit timeUnit) {
        return ((LongTaskTimer)this.firstChild()).duration(timeUnit);
    }

    @Override
    public int activeTasks() {
        return ((LongTaskTimer)this.firstChild()).activeTasks();
    }

    @Override
    public double max(TimeUnit timeUnit) {
        return ((LongTaskTimer)this.firstChild()).max(timeUnit);
    }

    @Override
    public TimeUnit baseTimeUnit() {
        return TimeUnit.SECONDS;
    }

    @Override
    public HistogramSnapshot takeSnapshot() {
        return ((LongTaskTimer)this.firstChild()).takeSnapshot();
    }

    @Override
    LongTaskTimer newNoopMeter() {
        return new NoopLongTaskTimer(this.getId());
    }

    @Override
    LongTaskTimer registerNewMeter(MeterRegistry meterRegistry) {
        LongTaskTimer.Builder builder = LongTaskTimer.builder(this.getId().getName()).tags(this.getId().getTagsAsIterable()).description(this.getId().getDescription()).maximumExpectedValue(Duration.ofNanos(this.distributionStatisticConfig.getMaximumExpectedValueAsDouble().longValue())).minimumExpectedValue(Duration.ofNanos(this.distributionStatisticConfig.getMinimumExpectedValueAsDouble().longValue())).publishPercentiles(this.distributionStatisticConfig.getPercentiles()).publishPercentileHistogram(this.distributionStatisticConfig.isPercentileHistogram()).distributionStatisticBufferLength(this.distributionStatisticConfig.getBufferLength()).distributionStatisticExpiry(this.distributionStatisticConfig.getExpiry()).percentilePrecision(this.distributionStatisticConfig.getPercentilePrecision());
        double[] dArray = this.distributionStatisticConfig.getServiceLevelObjectiveBoundaries();
        if (dArray != null) {
            Duration[] durationArray = new Duration[dArray.length];
            for (int i2 = 0; i2 < dArray.length; ++i2) {
                durationArray[i2] = Duration.ofNanos((long)dArray[i2]);
            }
            builder = builder.serviceLevelObjectives(durationArray);
        }
        return builder.register(meterRegistry);
    }

    static class CompositeSample
    extends LongTaskTimer.Sample {
        private final List<LongTaskTimer.Sample> samples;

        private CompositeSample(List<LongTaskTimer.Sample> list) {
            this.samples = list;
        }

        @Override
        public long stop() {
            return this.samples.stream().reduce(0L, (l2, sample) -> sample.stop(), (l2, l3) -> l2);
        }

        @Override
        public double duration(TimeUnit timeUnit) {
            return this.samples.stream().findAny().map(sample -> sample.duration(timeUnit)).orElse(0.0);
        }
    }
}

