/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.micrometer.core.instrument.config.validate;

import com.contrastsecurity.thirdparty.io.micrometer.core.annotation.Incubating;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.config.validate.InvalidReason;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.config.validate.Validated;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.util.StringUtils;
import com.contrastsecurity.thirdparty.io.micrometer.core.lang.Nullable;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

@Incubating(since="1.5.0")
public enum DurationValidator {
    SIMPLE(new String[]{"^\\s*(([\\+]?\\d+)(\\.\\d*)?)\\s*([a-zA-Z]{0,2})\\s*", "^\\s*([\\+]?\\d{0,3}([_,]?\\d{3})*(\\.\\d*)?)\\s*([a-zA-Z]{0,2})\\s*"}){

        @Override
        protected Validated<Duration> doParse(String string, String string2) {
            int n2;
            Matcher matcher = ((Pattern)this.patterns.get(0)).matcher(string2.toLowerCase().replaceAll("[,_\\s]", ""));
            if (!matcher.matches()) {
                return Validated.invalid(string, string2, "must be a valid duration", InvalidReason.MALFORMED);
            }
            String string3 = matcher.group(4);
            if (StringUtils.isBlank(string3)) {
                return Validated.invalid(string, string2, "must have a valid duration unit", InvalidReason.MALFORMED);
            }
            Double d2 = Double.valueOf(matcher.group(1));
            for (n2 = 0; n2 < 18 && Math.abs(d2 - (double)d2.longValue()) > 1.0E-10; ++n2) {
                d2 = d2 * 10.0;
            }
            long l2 = d2.longValue();
            long l3 = (long)Math.pow(10.0, n2);
            return 1.validateChronoUnit(string, string2, string3).map(chronoUnit -> Duration.of(l2, chronoUnit).dividedBy(l3));
        }
    }
    ,
    ISO8601(new String[]{"^[\\+\\-]?P.*$"}){

        @Override
        protected Validated<Duration> doParse(String string, String string2) {
            try {
                return Validated.valid(string, Duration.parse(string2));
            }
            catch (Exception exception) {
                return Validated.invalid(string, string2, "must be a valid ISO-8601 duration like 'PT10S'", InvalidReason.MALFORMED, exception);
            }
        }
    };

    protected final List<Pattern> patterns;

    private DurationValidator(String ... stringArray) {
        this.patterns = Arrays.stream(stringArray).map(Pattern::compile).collect(Collectors.toList());
    }

    public static Validated<Duration> validate(String string, @Nullable String string2) {
        return string2 == null ? Validated.valid(string, null) : DurationValidator.detect(string, string2).flatMap(durationValidator -> durationValidator.doParse(string, string2));
    }

    protected abstract Validated<Duration> doParse(String var1, String var2);

    private static Validated<DurationValidator> detect(String string, @Nullable String string2) {
        if (string2 == null || StringUtils.isBlank(string2)) {
            return Validated.invalid(string, string2, "must be a valid duration value", string2 == null ? InvalidReason.MISSING : InvalidReason.MALFORMED);
        }
        for (DurationValidator durationValidator : DurationValidator.values()) {
            if (!durationValidator.patterns.stream().anyMatch(pattern -> pattern.matcher(string2).matches())) continue;
            return Validated.valid(string, durationValidator);
        }
        return Validated.invalid(string, string2, "must be a valid duration value", InvalidReason.MALFORMED);
    }

    public static Validated<TimeUnit> validateTimeUnit(String string, @Nullable String string2) {
        return DurationValidator.validateChronoUnit(string, string2, string2).flatMap(chronoUnit -> DurationValidator.toTimeUnit(string, chronoUnit));
    }

    public static Validated<ChronoUnit> validateChronoUnit(String string, @Nullable String string2, @Nullable String string3) {
        if (string3 == null) {
            return Validated.valid(string, null);
        }
        switch (string3.toLowerCase()) {
            case "ns": 
            case "nanoseconds": 
            case "nanosecond": 
            case "nanos": {
                return Validated.valid(string, ChronoUnit.NANOS);
            }
            case "us": 
            case "microseconds": 
            case "microsecond": 
            case "micros": {
                return Validated.valid(string, ChronoUnit.MICROS);
            }
            case "ms": 
            case "milliseconds": 
            case "millisecond": 
            case "millis": {
                return Validated.valid(string, ChronoUnit.MILLIS);
            }
            case "s": 
            case "seconds": 
            case "second": 
            case "secs": 
            case "sec": {
                return Validated.valid(string, ChronoUnit.SECONDS);
            }
            case "m": 
            case "minutes": 
            case "minute": 
            case "mins": 
            case "min": {
                return Validated.valid(string, ChronoUnit.MINUTES);
            }
            case "h": 
            case "hours": 
            case "hour": {
                return Validated.valid(string, ChronoUnit.HOURS);
            }
            case "d": 
            case "days": 
            case "day": {
                return Validated.valid(string, ChronoUnit.DAYS);
            }
        }
        return Validated.invalid(string, string2, "must contain a valid time unit", InvalidReason.MALFORMED);
    }

    private static Validated<TimeUnit> toTimeUnit(String string, @Nullable ChronoUnit chronoUnit) {
        if (chronoUnit == null) {
            return Validated.valid(string, null);
        }
        switch (chronoUnit) {
            case NANOS: {
                return Validated.valid(string, TimeUnit.NANOSECONDS);
            }
            case MICROS: {
                return Validated.valid(string, TimeUnit.MICROSECONDS);
            }
            case MILLIS: {
                return Validated.valid(string, TimeUnit.MILLISECONDS);
            }
            case SECONDS: {
                return Validated.valid(string, TimeUnit.SECONDS);
            }
            case MINUTES: {
                return Validated.valid(string, TimeUnit.MINUTES);
            }
            case HOURS: {
                return Validated.valid(string, TimeUnit.HOURS);
            }
            case DAYS: {
                return Validated.valid(string, TimeUnit.DAYS);
            }
        }
        return Validated.invalid(string, chronoUnit.toString(), "must be a valid time unit", InvalidReason.MALFORMED);
    }
}

