/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.micrometer.core.instrument.config.validate;

import com.contrastsecurity.thirdparty.io.micrometer.core.annotation.Incubating;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.config.MeterRegistryConfig;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.config.validate.DurationValidator;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.config.validate.InvalidReason;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.config.validate.Validated;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URI;
import java.time.Duration;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

@Incubating(since="1.5.0")
public class PropertyValidator {
    private PropertyValidator() {
    }

    public static Validated<Duration> getDuration(MeterRegistryConfig meterRegistryConfig, String string) {
        String string2 = PropertyValidator.prefixedProperty(meterRegistryConfig, string);
        return DurationValidator.validate(string2, meterRegistryConfig.get(string2));
    }

    public static Validated<TimeUnit> getTimeUnit(MeterRegistryConfig meterRegistryConfig, String string) {
        String string2 = PropertyValidator.prefixedProperty(meterRegistryConfig, string);
        return DurationValidator.validateTimeUnit(string2, meterRegistryConfig.get(string2));
    }

    public static Validated<Integer> getInteger(MeterRegistryConfig meterRegistryConfig, String string) {
        String string2 = PropertyValidator.prefixedProperty(meterRegistryConfig, string);
        String string3 = meterRegistryConfig.get(string2);
        try {
            return Validated.valid(string2, string3 == null ? null : Integer.valueOf(string3));
        }
        catch (NumberFormatException numberFormatException) {
            return Validated.invalid(string2, string3, "must be an integer", InvalidReason.MALFORMED, numberFormatException);
        }
    }

    public static <E extends Enum<E>> Validated<E> getEnum(MeterRegistryConfig meterRegistryConfig, Class<E> clazz, String string) {
        String string2 = PropertyValidator.prefixedProperty(meterRegistryConfig, string);
        String string3 = meterRegistryConfig.get(string2);
        if (string3 == null) {
            return Validated.valid(string2, null);
        }
        try {
            Enum[] enumArray;
            for (Enum enum_2 : enumArray = (Enum[])clazz.getDeclaredMethod("values", new Class[0]).invoke(clazz, new Object[0])) {
                if (!enum_2.name().equalsIgnoreCase(string3)) continue;
                return Validated.valid(string2, enum_2);
            }
            return Validated.invalid(string2, string3, "should be one of " + Arrays.stream(enumArray).map(enum_ -> '\'' + enum_.name() + '\'').collect(Collectors.joining(", ")), InvalidReason.MALFORMED);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            throw new IllegalArgumentException(reflectiveOperationException);
        }
    }

    public static Validated<Boolean> getBoolean(MeterRegistryConfig meterRegistryConfig, String string) {
        String string2;
        String string3 = meterRegistryConfig.get(string2 = PropertyValidator.prefixedProperty(meterRegistryConfig, string));
        return Validated.valid(string2, string3 == null ? null : Boolean.valueOf(string3));
    }

    public static Validated<String> getSecret(MeterRegistryConfig meterRegistryConfig, String string) {
        String string2 = PropertyValidator.prefixedProperty(meterRegistryConfig, string);
        return Validated.validSecret(string2, meterRegistryConfig.get(string2));
    }

    public static Validated<String> getString(MeterRegistryConfig meterRegistryConfig, String string) {
        String string2 = PropertyValidator.prefixedProperty(meterRegistryConfig, string);
        return Validated.valid(string2, meterRegistryConfig.get(string2));
    }

    public static Validated<String> getUrlString(MeterRegistryConfig meterRegistryConfig, String string) {
        String string2 = PropertyValidator.prefixedProperty(meterRegistryConfig, string);
        String string3 = meterRegistryConfig.get(string2);
        try {
            return Validated.valid(string2, string3 == null ? null : URI.create(string3).toURL()).map(uRL -> string3);
        }
        catch (IllegalArgumentException | MalformedURLException exception) {
            return Validated.invalid(string2, string3, "must be a valid URL", InvalidReason.MALFORMED, exception);
        }
    }

    private static String prefixedProperty(MeterRegistryConfig meterRegistryConfig, String string) {
        return meterRegistryConfig.prefix() + '.' + string;
    }
}

