/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.micrometer.core.instrument.distribution;

import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Clock;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.config.InvalidConfigurationException;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.distribution.CountAtBucket;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.distribution.Histogram;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.distribution.HistogramSnapshot;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.distribution.ValueAtPercentile;
import com.contrastsecurity.thirdparty.io.micrometer.core.lang.Nullable;
import java.io.PrintStream;
import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.NavigableSet;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

abstract class AbstractTimeWindowHistogram<T, U>
implements Histogram {
    private static final AtomicIntegerFieldUpdater<AbstractTimeWindowHistogram> rotatingUpdater = AtomicIntegerFieldUpdater.newUpdater(AbstractTimeWindowHistogram.class, "rotating");
    final DistributionStatisticConfig distributionStatisticConfig;
    private final Clock clock;
    private final boolean supportsAggregablePercentiles;
    private final T[] ringBuffer;
    private short currentBucket;
    private final long durationBetweenRotatesMillis;
    private volatile boolean accumulatedHistogramStale;
    private volatile long lastRotateTimestampMillis;
    private volatile int rotating;
    @Nullable
    private U accumulatedHistogram;

    AbstractTimeWindowHistogram(Clock clock, DistributionStatisticConfig distributionStatisticConfig, Class<T> clazz, boolean bl) {
        this.clock = clock;
        this.distributionStatisticConfig = AbstractTimeWindowHistogram.validateDistributionConfig(distributionStatisticConfig);
        this.supportsAggregablePercentiles = bl;
        int n2 = distributionStatisticConfig.getBufferLength();
        if (n2 <= 0) {
            AbstractTimeWindowHistogram.rejectHistogramConfig("bufferLength (" + n2 + ") must be greater than 0.");
        }
        this.ringBuffer = (Object[])Array.newInstance(clazz, n2);
        this.durationBetweenRotatesMillis = distributionStatisticConfig.getExpiry().toMillis() / (long)n2;
        if (this.durationBetweenRotatesMillis <= 0L) {
            AbstractTimeWindowHistogram.rejectHistogramConfig("expiry (" + distributionStatisticConfig.getExpiry().toMillis() + "ms) / bufferLength (" + n2 + ") must be greater than 0.");
        }
        this.currentBucket = 0;
        this.lastRotateTimestampMillis = clock.wallTime();
    }

    private static DistributionStatisticConfig validateDistributionConfig(DistributionStatisticConfig distributionStatisticConfig) {
        if (distributionStatisticConfig.getPercentiles() != null) {
            for (double d2 : distributionStatisticConfig.getPercentiles()) {
                if (!(d2 < 0.0) && !(d2 > 1.0)) continue;
                AbstractTimeWindowHistogram.rejectHistogramConfig("percentiles must contain only the values between 0.0 and 1.0. Found " + (double)d2);
            }
            if (distributionStatisticConfig.getPercentilePrecision() == null) {
                AbstractTimeWindowHistogram.rejectHistogramConfig("when publishing percentiles a precision must be specified.");
            }
        }
        Object object = distributionStatisticConfig.getMinimumExpectedValueAsDouble();
        Double d3 = distributionStatisticConfig.getMaximumExpectedValueAsDouble();
        if (object == null || (Double)object <= 0.0) {
            AbstractTimeWindowHistogram.rejectHistogramConfig("minimumExpectedValue (" + object + ") must be greater than 0.");
        }
        if (d3 == null || d3 < (Double)object) {
            AbstractTimeWindowHistogram.rejectHistogramConfig("maximumExpectedValue (" + d3 + ") must be equal to or greater than minimumExpectedValue (" + object + ").");
        }
        if (distributionStatisticConfig.getServiceLevelObjectiveBoundaries() != null) {
            for (double d4 : distributionStatisticConfig.getServiceLevelObjectiveBoundaries()) {
                if (!(d4 <= 0.0)) continue;
                AbstractTimeWindowHistogram.rejectHistogramConfig("serviceLevelObjectiveBoundaries must contain only the values greater than 0. Found " + d4);
            }
        }
        return distributionStatisticConfig;
    }

    private static void rejectHistogramConfig(String string) {
        throw new InvalidConfigurationException("Invalid distribution configuration: " + string);
    }

    void initRingBuffer() {
        for (int i2 = 0; i2 < this.ringBuffer.length; ++i2) {
            this.ringBuffer[i2] = this.newBucket();
        }
        this.accumulatedHistogram = this.newAccumulatedHistogram(this.ringBuffer);
    }

    abstract T newBucket();

    abstract void recordLong(T var1, long var2);

    abstract void recordDouble(T var1, double var2);

    abstract void resetBucket(T var1);

    abstract U newAccumulatedHistogram(T[] var1);

    abstract void accumulate();

    abstract void resetAccumulatedHistogram();

    abstract double valueAtPercentile(double var1);

    abstract double countAtValue(double var1);

    double countAtValue(long l2) {
        return this.countAtValue((double)l2);
    }

    void outputSummary(PrintStream printStream, double d2) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final HistogramSnapshot takeSnapshot(long l2, double d2, double d3) {
        CountAtBucket[] countAtBucketArray;
        ValueAtPercentile[] valueAtPercentileArray;
        this.rotate();
        AbstractTimeWindowHistogram abstractTimeWindowHistogram = this;
        synchronized (abstractTimeWindowHistogram) {
            this.accumulateIfStale();
            valueAtPercentileArray = this.takeValueSnapshot();
            countAtBucketArray = this.takeCountSnapshot();
        }
        return new HistogramSnapshot(l2, d2, d3, valueAtPercentileArray, countAtBucketArray, this::outputSummary);
    }

    private void accumulateIfStale() {
        if (this.accumulatedHistogramStale) {
            this.accumulate();
            this.accumulatedHistogramStale = false;
        }
    }

    private ValueAtPercentile[] takeValueSnapshot() {
        double[] dArray = this.distributionStatisticConfig.getPercentiles();
        if (dArray == null || dArray.length == 0) {
            return null;
        }
        ValueAtPercentile[] valueAtPercentileArray = new ValueAtPercentile[dArray.length];
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            double d2 = dArray[i2];
            valueAtPercentileArray[i2] = new ValueAtPercentile(d2, this.valueAtPercentile(d2 * 100.0));
        }
        return valueAtPercentileArray;
    }

    private CountAtBucket[] takeCountSnapshot() {
        if (!this.distributionStatisticConfig.isPublishingHistogram()) {
            return null;
        }
        NavigableSet<Double> navigableSet = this.distributionStatisticConfig.getHistogramBuckets(this.supportsAggregablePercentiles);
        if (navigableSet.isEmpty()) {
            return null;
        }
        CountAtBucket[] countAtBucketArray = new CountAtBucket[navigableSet.size()];
        Iterator iterator = navigableSet.iterator();
        for (int i2 = 0; i2 < countAtBucketArray.length; ++i2) {
            double d2 = (Double)iterator.next();
            countAtBucketArray[i2] = new CountAtBucket(d2, this.countAtValue(d2));
        }
        return countAtBucketArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recordLong(long l2) {
        this.rotate();
        try {
            for (T t2 : this.ringBuffer) {
                this.recordLong(t2, l2);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
        }
        finally {
            this.accumulatedHistogramStale = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recordDouble(double d2) {
        this.rotate();
        try {
            for (T t2 : this.ringBuffer) {
                this.recordDouble(t2, d2);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
        }
        finally {
            this.accumulatedHistogramStale = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rotate() {
        long l2 = this.clock.wallTime() - this.lastRotateTimestampMillis;
        if (l2 < this.durationBetweenRotatesMillis) {
            return;
        }
        if (!rotatingUpdater.compareAndSet(this, 0, 1)) {
            return;
        }
        try {
            int n2 = 0;
            AbstractTimeWindowHistogram abstractTimeWindowHistogram = this;
            synchronized (abstractTimeWindowHistogram) {
                do {
                    this.resetBucket(this.ringBuffer[this.currentBucket]);
                    this.currentBucket = (short)(this.currentBucket + 1);
                    if (this.currentBucket >= this.ringBuffer.length) {
                        this.currentBucket = 0;
                    }
                    this.lastRotateTimestampMillis += this.durationBetweenRotatesMillis;
                } while ((l2 -= this.durationBetweenRotatesMillis) >= this.durationBetweenRotatesMillis && ++n2 < this.ringBuffer.length);
                this.resetAccumulatedHistogram();
                this.accumulatedHistogramStale = true;
            }
        }
        finally {
            this.rotating = 0;
        }
    }

    protected U accumulatedHistogram() {
        return this.accumulatedHistogram;
    }

    protected T currentHistogram() {
        return this.ringBuffer[this.currentBucket];
    }
}

