/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.micrometer.core.instrument.distribution;

import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Clock;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.distribution.AbstractTimeWindowHistogram;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.distribution.PercentileHistogramBuckets;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Locale;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLongArray;

public class TimeWindowFixedBoundaryHistogram
extends AbstractTimeWindowHistogram<FixedBoundaryHistogram, Void> {
    private final double[] buckets;

    public TimeWindowFixedBoundaryHistogram(Clock clock, DistributionStatisticConfig distributionStatisticConfig, boolean bl) {
        super(clock, distributionStatisticConfig, FixedBoundaryHistogram.class, bl);
        NavigableSet<Double> navigableSet = this.distributionStatisticConfig.getHistogramBuckets(bl);
        Boolean bl2 = this.distributionStatisticConfig.isPercentileHistogram();
        if (bl2 != null && bl2.booleanValue()) {
            navigableSet.addAll(PercentileHistogramBuckets.buckets(this.distributionStatisticConfig));
        }
        this.buckets = navigableSet.stream().filter(Objects::nonNull).mapToDouble(Double::doubleValue).toArray();
        this.initRingBuffer();
    }

    @Override
    FixedBoundaryHistogram newBucket() {
        return new FixedBoundaryHistogram();
    }

    @Override
    void recordLong(FixedBoundaryHistogram fixedBoundaryHistogram, long l2) {
        fixedBoundaryHistogram.record(l2);
    }

    @Override
    final void recordDouble(FixedBoundaryHistogram fixedBoundaryHistogram, double d2) {
        this.recordLong(fixedBoundaryHistogram, (long)Math.ceil(d2));
    }

    @Override
    void resetBucket(FixedBoundaryHistogram fixedBoundaryHistogram) {
        fixedBoundaryHistogram.reset();
    }

    Void newAccumulatedHistogram(FixedBoundaryHistogram[] fixedBoundaryHistogramArray) {
        return null;
    }

    @Override
    void accumulate() {
    }

    @Override
    void resetAccumulatedHistogram() {
    }

    @Override
    double valueAtPercentile(double d2) {
        return 0.0;
    }

    @Override
    double countAtValue(double d2) {
        return ((FixedBoundaryHistogram)this.currentHistogram()).countAtValue(d2);
    }

    @Override
    void outputSummary(PrintStream printStream, double d2) {
        printStream.format("%14s %10s\n\n", "Bucket", "TotalCount");
        String string = "%14.1f %10d\n";
        for (int i2 = 0; i2 < this.buckets.length; ++i2) {
            printStream.format(Locale.US, string, this.buckets[i2] / d2, ((FixedBoundaryHistogram)this.currentHistogram()).values.get(i2));
        }
        printStream.write(10);
    }

    class FixedBoundaryHistogram {
        final AtomicLongArray values;

        FixedBoundaryHistogram() {
            this.values = new AtomicLongArray(TimeWindowFixedBoundaryHistogram.this.buckets.length);
        }

        long countAtValue(double d2) {
            int n2 = Arrays.binarySearch(TimeWindowFixedBoundaryHistogram.this.buckets, d2);
            if (n2 < 0) {
                return 0L;
            }
            long l2 = 0L;
            for (int i2 = 0; i2 <= n2; ++i2) {
                l2 += this.values.get(i2);
            }
            return l2;
        }

        void reset() {
            for (int i2 = 0; i2 < this.values.length(); ++i2) {
                this.values.set(i2, 0L);
            }
        }

        void record(long l2) {
            int n2 = this.leastLessThanOrEqualTo(l2);
            if (n2 > -1) {
                this.values.incrementAndGet(n2);
            }
        }

        int leastLessThanOrEqualTo(long l2) {
            int n2 = 0;
            int n3 = TimeWindowFixedBoundaryHistogram.this.buckets.length - 1;
            while (n2 <= n3) {
                int n4 = n2 + n3 >>> 1;
                if (TimeWindowFixedBoundaryHistogram.this.buckets[n4] < (double)l2) {
                    n2 = n4 + 1;
                    continue;
                }
                if (TimeWindowFixedBoundaryHistogram.this.buckets[n4] > (double)l2) {
                    n3 = n4 - 1;
                    continue;
                }
                return n4;
            }
            return n2 < TimeWindowFixedBoundaryHistogram.this.buckets.length ? n2 : -1;
        }
    }
}

