/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.micrometer.core.instrument.distribution;

import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Clock;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.distribution.AbstractTimeWindowHistogram;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import com.contrastsecurity.thirdparty.org.HdrHistogram.DoubleHistogram;
import com.contrastsecurity.thirdparty.org.HdrHistogram.DoubleRecorder;
import java.io.PrintStream;

public class TimeWindowPercentileHistogram
extends AbstractTimeWindowHistogram<DoubleRecorder, DoubleHistogram> {
    private final DoubleHistogram intervalHistogram;

    public TimeWindowPercentileHistogram(Clock clock, DistributionStatisticConfig distributionStatisticConfig, boolean bl) {
        super(clock, distributionStatisticConfig, DoubleRecorder.class, bl);
        this.intervalHistogram = new DoubleHistogram(this.percentilePrecision(distributionStatisticConfig));
        this.initRingBuffer();
    }

    @Override
    DoubleRecorder newBucket() {
        return new DoubleRecorder(this.percentilePrecision(this.distributionStatisticConfig));
    }

    @Override
    void recordDouble(DoubleRecorder doubleRecorder, double d2) {
        doubleRecorder.recordValue(d2);
    }

    @Override
    void recordLong(DoubleRecorder doubleRecorder, long l2) {
        doubleRecorder.recordValue(l2);
    }

    @Override
    void resetBucket(DoubleRecorder doubleRecorder) {
        doubleRecorder.reset();
    }

    DoubleHistogram newAccumulatedHistogram(DoubleRecorder[] doubleRecorderArray) {
        return new DoubleHistogram(this.percentilePrecision(this.distributionStatisticConfig));
    }

    @Override
    void accumulate() {
        ((DoubleRecorder)this.currentHistogram()).getIntervalHistogramInto(this.intervalHistogram);
        ((DoubleHistogram)this.accumulatedHistogram()).add(this.intervalHistogram);
    }

    @Override
    void resetAccumulatedHistogram() {
        ((DoubleHistogram)this.accumulatedHistogram()).reset();
    }

    @Override
    double valueAtPercentile(double d2) {
        return ((DoubleHistogram)this.accumulatedHistogram()).getValueAtPercentile(d2);
    }

    @Override
    double countAtValue(double d2) {
        return ((DoubleHistogram)this.accumulatedHistogram()).getCountBetweenValues(0.0, d2);
    }

    private int percentilePrecision(DistributionStatisticConfig distributionStatisticConfig) {
        return distributionStatisticConfig.getPercentilePrecision() == null ? 1 : distributionStatisticConfig.getPercentilePrecision();
    }

    @Override
    void outputSummary(PrintStream printStream, double d2) {
        ((DoubleHistogram)this.accumulatedHistogram()).outputPercentileDistribution(printStream, d2);
    }
}

