/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.micrometer.core.instrument.distribution;

import java.time.Duration;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLong;

public class TimeWindowSum {
    private static final AtomicIntegerFieldUpdater<TimeWindowSum> rotatingUpdater = AtomicIntegerFieldUpdater.newUpdater(TimeWindowSum.class, "rotating");
    private final long durationBetweenRotatesMillis;
    private AtomicLong[] ringBuffer;
    private int currentBucket;
    private volatile long lastRotateTimestampMillis;
    private volatile int rotating;

    public TimeWindowSum(int n2, Duration duration) {
        this.durationBetweenRotatesMillis = duration.toMillis();
        this.lastRotateTimestampMillis = System.currentTimeMillis();
        this.currentBucket = 0;
        this.ringBuffer = new AtomicLong[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            this.ringBuffer[i2] = new AtomicLong();
        }
    }

    public void record(long l2) {
        this.rotate();
        for (AtomicLong atomicLong : this.ringBuffer) {
            atomicLong.addAndGet(l2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double poll() {
        this.rotate();
        TimeWindowSum timeWindowSum = this;
        synchronized (timeWindowSum) {
            return this.ringBuffer[this.currentBucket].get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rotate() {
        long l2 = System.currentTimeMillis() - this.lastRotateTimestampMillis;
        if (l2 < this.durationBetweenRotatesMillis) {
            return;
        }
        if (!rotatingUpdater.compareAndSet(this, 0, 1)) {
            return;
        }
        try {
            int n2 = 0;
            TimeWindowSum timeWindowSum = this;
            synchronized (timeWindowSum) {
                do {
                    this.ringBuffer[this.currentBucket].set(0L);
                    if (++this.currentBucket >= this.ringBuffer.length) {
                        this.currentBucket = 0;
                    }
                    this.lastRotateTimestampMillis += this.durationBetweenRotatesMillis;
                } while ((l2 -= this.durationBetweenRotatesMillis) >= this.durationBetweenRotatesMillis && ++n2 < this.ringBuffer.length);
            }
        }
        finally {
            this.rotating = 0;
        }
    }
}

