/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.micrometer.core.instrument.dropwizard;

import com.codahale.metrics.Meter;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.AbstractMeter;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Clock;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.FunctionCounter;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Meter;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.dropwizard.DropwizardClock;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.dropwizard.DropwizardRate;
import java.lang.ref.WeakReference;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.ToDoubleFunction;

public class DropwizardFunctionCounter<T>
extends AbstractMeter
implements FunctionCounter {
    private final WeakReference<T> ref;
    private final ToDoubleFunction<T> f;
    private final AtomicLong last = new AtomicLong();
    private final DropwizardRate rate;
    private final Meter dropwizardMeter;

    DropwizardFunctionCounter(Meter.Id id, Clock clock, T t2, ToDoubleFunction<T> toDoubleFunction) {
        super(id);
        this.ref = new WeakReference<T>(t2);
        this.f = toDoubleFunction;
        this.rate = new DropwizardRate(clock);
        this.dropwizardMeter = new Meter(new DropwizardClock(clock)){

            public double getFifteenMinuteRate() {
                DropwizardFunctionCounter.this.count();
                return DropwizardFunctionCounter.this.rate.getFifteenMinuteRate();
            }

            public double getFiveMinuteRate() {
                DropwizardFunctionCounter.this.count();
                return DropwizardFunctionCounter.this.rate.getFiveMinuteRate();
            }

            public double getOneMinuteRate() {
                DropwizardFunctionCounter.this.count();
                return DropwizardFunctionCounter.this.rate.getOneMinuteRate();
            }

            public long getCount() {
                return (long)DropwizardFunctionCounter.this.count();
            }
        };
    }

    public Meter getDropwizardMeter() {
        return this.dropwizardMeter;
    }

    @Override
    public double count() {
        Object t2 = this.ref.get();
        if (t2 == null) {
            return this.last.get();
        }
        return this.last.updateAndGet(l2 -> {
            long l3 = (long)this.f.applyAsDouble(t2);
            long l4 = l3 - l2;
            this.rate.increment(l4);
            return l3;
        });
    }
}

