/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.micrometer.core.instrument.dropwizard;

import com.codahale.metrics.Snapshot;
import com.codahale.metrics.Timer;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.AbstractMeter;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Clock;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.FunctionTimer;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Meter;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.dropwizard.DropwizardClock;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.dropwizard.DropwizardRate;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.util.TimeUtils;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.ToDoubleFunction;
import java.util.function.ToLongFunction;

public class DropwizardFunctionTimer<T>
extends AbstractMeter
implements FunctionTimer {
    private final WeakReference<T> ref;
    private final ToLongFunction<T> countFunction;
    private final ToDoubleFunction<T> totalTimeFunction;
    private final TimeUnit totalTimeFunctionUnit;
    private final AtomicLong lastCount = new AtomicLong();
    private final DropwizardRate rate;
    private final Timer dropwizardMeter;
    private final TimeUnit registryBaseTimeUnit;
    private volatile double lastTime;

    DropwizardFunctionTimer(Meter.Id id, Clock clock, T t2, ToLongFunction<T> toLongFunction, ToDoubleFunction<T> toDoubleFunction, TimeUnit timeUnit, TimeUnit timeUnit2) {
        super(id);
        this.ref = new WeakReference<T>(t2);
        this.countFunction = toLongFunction;
        this.totalTimeFunction = toDoubleFunction;
        this.totalTimeFunctionUnit = timeUnit;
        this.rate = new DropwizardRate(clock);
        this.registryBaseTimeUnit = timeUnit2;
        this.dropwizardMeter = new Timer(null, new DropwizardClock(clock)){

            public double getFifteenMinuteRate() {
                DropwizardFunctionTimer.this.count();
                return DropwizardFunctionTimer.this.rate.getFifteenMinuteRate();
            }

            public double getFiveMinuteRate() {
                DropwizardFunctionTimer.this.count();
                return DropwizardFunctionTimer.this.rate.getFiveMinuteRate();
            }

            public double getOneMinuteRate() {
                DropwizardFunctionTimer.this.count();
                return DropwizardFunctionTimer.this.rate.getOneMinuteRate();
            }

            public long getCount() {
                return (long)DropwizardFunctionTimer.this.count();
            }

            public Snapshot getSnapshot() {
                return new Snapshot(){

                    public double getValue(double d2) {
                        return d2 == 0.5 ? this.getMean() : 0.0;
                    }

                    public long[] getValues() {
                        return new long[0];
                    }

                    public int size() {
                        return 1;
                    }

                    public long getMax() {
                        return 0L;
                    }

                    public double getMean() {
                        double d2 = DropwizardFunctionTimer.this.count();
                        return d2 == 0.0 ? 0.0 : DropwizardFunctionTimer.this.totalTime(TimeUnit.NANOSECONDS) / d2;
                    }

                    public long getMin() {
                        return 0L;
                    }

                    public double getStdDev() {
                        return 0.0;
                    }

                    public void dump(OutputStream outputStream) {
                    }
                };
            }
        };
    }

    public Timer getDropwizardMeter() {
        return this.dropwizardMeter;
    }

    @Override
    public double count() {
        Object t2 = this.ref.get();
        if (t2 == null) {
            return this.lastCount.get();
        }
        return this.lastCount.updateAndGet(l2 -> {
            long l3 = this.countFunction.applyAsLong(t2);
            long l4 = l3 - l2;
            this.rate.increment(l4);
            return l3;
        });
    }

    @Override
    public double totalTime(TimeUnit timeUnit) {
        Object t2 = this.ref.get();
        if (t2 != null) {
            this.lastTime = TimeUtils.convert(this.totalTimeFunction.applyAsDouble(t2), this.totalTimeFunctionUnit, this.baseTimeUnit());
        }
        return TimeUtils.convert(this.lastTime, this.baseTimeUnit(), timeUnit);
    }

    @Override
    public TimeUnit baseTimeUnit() {
        return this.registryBaseTimeUnit;
    }
}

