/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.micrometer.core.instrument.dropwizard;

import com.codahale.metrics.ExponentiallyDecayingReservoir;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Reservoir;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Clock;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Counter;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.DistributionSummary;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.FunctionCounter;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.FunctionTimer;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Gauge;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.LongTaskTimer;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Measurement;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Meter;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.MeterRegistry;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Statistic;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Timer;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.config.NamingConvention;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.distribution.HistogramGauges;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.distribution.pause.PauseDetector;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.dropwizard.DropwizardClock;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.dropwizard.DropwizardConfig;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.dropwizard.DropwizardCounter;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.dropwizard.DropwizardDistributionSummary;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.dropwizard.DropwizardFunctionCounter;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.dropwizard.DropwizardFunctionTimer;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.dropwizard.DropwizardGauge;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.dropwizard.DropwizardTimer;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.internal.DefaultLongTaskTimer;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.internal.DefaultMeter;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.util.HierarchicalNameMapper;
import com.contrastsecurity.thirdparty.io.micrometer.core.lang.Nullable;
import com.contrastsecurity.thirdparty.io.micrometer.core.util.internal.logging.WarnThenDebugLogger;
import java.lang.ref.WeakReference;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.ToDoubleFunction;
import java.util.function.ToLongFunction;

public abstract class DropwizardMeterRegistry
extends MeterRegistry {
    private static final WarnThenDebugLogger logger = new WarnThenDebugLogger(DropwizardMeterRegistry.class);
    private final MetricRegistry registry;
    private final HierarchicalNameMapper nameMapper;
    private final DropwizardClock dropwizardClock;
    private final DropwizardConfig dropwizardConfig;
    private final AtomicBoolean warnLogged = new AtomicBoolean();

    public DropwizardMeterRegistry(DropwizardConfig dropwizardConfig, MetricRegistry metricRegistry, HierarchicalNameMapper hierarchicalNameMapper, Clock clock) {
        super(clock);
        dropwizardConfig.requireValid();
        this.dropwizardConfig = dropwizardConfig;
        this.dropwizardClock = new DropwizardClock(clock);
        this.registry = metricRegistry;
        this.nameMapper = hierarchicalNameMapper;
        this.config().namingConvention(NamingConvention.camelCase).onMeterRemoved(this::onMeterRemoved);
    }

    private void onMeterRemoved(Meter meter) {
        this.registry.remove(this.hierarchicalName(meter.getId()));
    }

    public MetricRegistry getDropwizardRegistry() {
        return this.registry;
    }

    @Override
    protected Counter newCounter(Meter.Id id) {
        com.codahale.metrics.Meter meter = new com.codahale.metrics.Meter((com.codahale.metrics.Clock)this.dropwizardClock);
        this.registry.register(this.hierarchicalName(id), (Metric)meter);
        return new DropwizardCounter(id, meter);
    }

    @Override
    protected <T> Gauge newGauge(Meter.Id id, @Nullable T t2, ToDoubleFunction<T> toDoubleFunction) {
        WeakReference weakReference = new WeakReference(t2);
        com.codahale.metrics.Gauge gauge = () -> {
            Object t2 = weakReference.get();
            if (t2 != null) {
                try {
                    return toDoubleFunction.applyAsDouble(t2);
                }
                catch (Throwable throwable) {
                    logger.log("Failed to apply the value function for the gauge '" + id.getName() + "'.", throwable);
                }
            }
            return this.nullGaugeValue();
        };
        this.registry.register(this.hierarchicalName(id), (Metric)gauge);
        return new DropwizardGauge(id, (com.codahale.metrics.Gauge<Double>)gauge);
    }

    @Override
    protected Timer newTimer(Meter.Id id, DistributionStatisticConfig distributionStatisticConfig, PauseDetector pauseDetector) {
        DropwizardTimer dropwizardTimer = new DropwizardTimer(id, this.registry.timer(this.hierarchicalName(id), () -> new com.codahale.metrics.Timer((Reservoir)new ExponentiallyDecayingReservoir(), (com.codahale.metrics.Clock)this.dropwizardClock)), this.clock, distributionStatisticConfig, pauseDetector);
        HistogramGauges.registerWithCommonFormat(dropwizardTimer, (MeterRegistry)this);
        return dropwizardTimer;
    }

    @Override
    protected DistributionSummary newDistributionSummary(Meter.Id id, DistributionStatisticConfig distributionStatisticConfig, double d2) {
        DropwizardDistributionSummary dropwizardDistributionSummary = new DropwizardDistributionSummary(id, this.clock, this.registry.histogram(this.hierarchicalName(id)), distributionStatisticConfig, d2);
        HistogramGauges.registerWithCommonFormat(dropwizardDistributionSummary, (MeterRegistry)this);
        return dropwizardDistributionSummary;
    }

    @Override
    protected LongTaskTimer newLongTaskTimer(Meter.Id id, DistributionStatisticConfig distributionStatisticConfig) {
        DefaultLongTaskTimer defaultLongTaskTimer = new DefaultLongTaskTimer(id, this.clock, this.getBaseTimeUnit(), distributionStatisticConfig, false);
        this.registry.register(this.hierarchicalName(id.withTag(Statistic.ACTIVE_TASKS)), (Metric)((com.codahale.metrics.Gauge)defaultLongTaskTimer::activeTasks));
        this.registry.register(this.hierarchicalName(id.withTag(Statistic.DURATION)), (Metric)((com.codahale.metrics.Gauge)() -> defaultLongTaskTimer.duration(TimeUnit.NANOSECONDS)));
        this.registry.register(this.hierarchicalName(id.withTag(Statistic.MAX)), (Metric)((com.codahale.metrics.Gauge)() -> defaultLongTaskTimer.max(TimeUnit.NANOSECONDS)));
        HistogramGauges.registerWithCommonFormat(defaultLongTaskTimer, (MeterRegistry)this);
        return defaultLongTaskTimer;
    }

    @Override
    protected <T> FunctionTimer newFunctionTimer(Meter.Id id, T t2, ToLongFunction<T> toLongFunction, ToDoubleFunction<T> toDoubleFunction, TimeUnit timeUnit) {
        DropwizardFunctionTimer<T> dropwizardFunctionTimer = new DropwizardFunctionTimer<T>(id, this.clock, t2, toLongFunction, toDoubleFunction, timeUnit, this.getBaseTimeUnit());
        this.registry.register(this.hierarchicalName(id), (Metric)dropwizardFunctionTimer.getDropwizardMeter());
        return dropwizardFunctionTimer;
    }

    @Override
    protected <T> FunctionCounter newFunctionCounter(Meter.Id id, T t2, ToDoubleFunction<T> toDoubleFunction) {
        DropwizardFunctionCounter<T> dropwizardFunctionCounter = new DropwizardFunctionCounter<T>(id, this.clock, t2, toDoubleFunction);
        this.registry.register(this.hierarchicalName(id), (Metric)dropwizardFunctionCounter.getDropwizardMeter());
        return dropwizardFunctionCounter;
    }

    @Override
    protected Meter newMeter(Meter.Id id, Meter.Type type, Iterable<Measurement> iterable) {
        iterable.forEach(measurement -> this.registry.register(this.hierarchicalName(id.withTag(measurement.getStatistic())), (Metric)((com.codahale.metrics.Gauge)measurement::getValue)));
        return new DefaultMeter(id, type, iterable);
    }

    @Override
    protected TimeUnit getBaseTimeUnit() {
        return TimeUnit.MILLISECONDS;
    }

    private String hierarchicalName(Meter.Id id) {
        return this.nameMapper.toHierarchicalName(id, this.config().namingConvention());
    }

    @Override
    protected DistributionStatisticConfig defaultHistogramConfig() {
        return DistributionStatisticConfig.builder().expiry(this.dropwizardConfig.step()).build().merge(DistributionStatisticConfig.DEFAULT);
    }

    protected abstract Double nullGaugeValue();
}

