/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.micrometer.core.instrument.internal;

import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.AbstractMeter;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Gauge;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Meter;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.util.MeterEquivalence;
import com.contrastsecurity.thirdparty.io.micrometer.core.lang.Nullable;
import com.contrastsecurity.thirdparty.io.micrometer.core.util.internal.logging.WarnThenDebugLogger;
import java.lang.ref.WeakReference;
import java.util.function.ToDoubleFunction;

public class DefaultGauge<T>
extends AbstractMeter
implements Gauge {
    private static final WarnThenDebugLogger logger = new WarnThenDebugLogger(DefaultGauge.class);
    private final WeakReference<T> ref;
    private final ToDoubleFunction<T> value;

    public DefaultGauge(Meter.Id id, @Nullable T t2, ToDoubleFunction<T> toDoubleFunction) {
        super(id);
        this.ref = new WeakReference<T>(t2);
        this.value = toDoubleFunction;
    }

    @Override
    public double value() {
        Object t2 = this.ref.get();
        if (t2 != null) {
            try {
                return this.value.applyAsDouble(t2);
            }
            catch (Throwable throwable) {
                logger.log("Failed to apply the value function for the gauge '" + this.getId().getName() + "'.", throwable);
            }
        }
        return Double.NaN;
    }

    public boolean equals(Object object) {
        return MeterEquivalence.equals(this, object);
    }

    public int hashCode() {
        return MeterEquivalence.hashCode(this);
    }
}

