/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.micrometer.core.instrument.internal;

import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Counter;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.MeterRegistry;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Tag;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Tags;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Timer;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.internal.TimedCallable;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.internal.TimedRunnable;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;

public class TimedScheduledExecutorService
implements ScheduledExecutorService {
    private final MeterRegistry registry;
    private final ScheduledExecutorService delegate;
    private final Timer executionTimer;
    private final Timer idleTimer;
    private final Counter scheduledOnce;
    private final Counter scheduledRepetitively;

    public TimedScheduledExecutorService(MeterRegistry meterRegistry, ScheduledExecutorService scheduledExecutorService, String string, String string2, Iterable<Tag> iterable) {
        this.registry = meterRegistry;
        this.delegate = scheduledExecutorService;
        Tags tags = Tags.concat(iterable, "name", string);
        this.executionTimer = meterRegistry.timer(string2 + "executor", tags);
        this.idleTimer = meterRegistry.timer(string2 + "executor.idle", tags);
        this.scheduledOnce = meterRegistry.counter(string2 + "executor.scheduled.once", tags);
        this.scheduledRepetitively = meterRegistry.counter(string2 + "executor.scheduled.repetitively", tags);
    }

    @Override
    public void shutdown() {
        this.delegate.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.delegate.shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return this.delegate.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.delegate.isTerminated();
    }

    @Override
    public boolean awaitTermination(long l2, TimeUnit timeUnit) throws InterruptedException {
        return this.delegate.awaitTermination(l2, timeUnit);
    }

    @Override
    public <T> Future<T> submit(Callable<T> callable) {
        return this.delegate.submit(this.wrap(callable));
    }

    @Override
    public <T> Future<T> submit(Runnable runnable, T t2) {
        return this.delegate.submit(this.wrap(runnable), t2);
    }

    @Override
    public Future<?> submit(Runnable runnable) {
        return this.delegate.submit(this.wrap(runnable));
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> collection) throws InterruptedException {
        return this.delegate.invokeAll(this.wrapAll(collection));
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> collection, long l2, TimeUnit timeUnit) throws InterruptedException {
        return this.delegate.invokeAll(this.wrapAll(collection), l2, timeUnit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> collection) throws InterruptedException, ExecutionException {
        return this.delegate.invokeAny(this.wrapAll(collection));
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> collection, long l2, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.delegate.invokeAny(this.wrapAll(collection), l2, timeUnit);
    }

    @Override
    public void execute(Runnable runnable) {
        this.delegate.execute(this.wrap(runnable));
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable runnable, long l2, TimeUnit timeUnit) {
        this.scheduledOnce.increment();
        return this.delegate.schedule(this.executionTimer.wrap(runnable), l2, timeUnit);
    }

    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long l2, TimeUnit timeUnit) {
        this.scheduledOnce.increment();
        return this.delegate.schedule(this.executionTimer.wrap(callable), l2, timeUnit);
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable runnable, long l2, long l3, TimeUnit timeUnit) {
        this.scheduledRepetitively.increment();
        return this.delegate.scheduleAtFixedRate(this.executionTimer.wrap(runnable), l2, l3, timeUnit);
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable runnable, long l2, long l3, TimeUnit timeUnit) {
        this.scheduledRepetitively.increment();
        return this.delegate.scheduleWithFixedDelay(this.executionTimer.wrap(runnable), l2, l3, timeUnit);
    }

    private Runnable wrap(Runnable runnable) {
        return new TimedRunnable(this.registry, this.executionTimer, this.idleTimer, runnable);
    }

    private <T> Callable<T> wrap(Callable<T> callable) {
        return new TimedCallable<T>(this.registry, this.executionTimer, this.idleTimer, callable);
    }

    private <T> Collection<? extends Callable<T>> wrapAll(Collection<? extends Callable<T>> collection) {
        return collection.stream().map(this::wrap).collect(Collectors.toList());
    }
}

