/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.micrometer.core.instrument.push;

import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Clock;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.MeterRegistry;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.push.PushRegistryConfig;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.util.TimeUtils;
import com.contrastsecurity.thirdparty.io.micrometer.core.lang.Nullable;
import com.contrastsecurity.thirdparty.io.micrometer.core.util.internal.logging.InternalLogger;
import com.contrastsecurity.thirdparty.io.micrometer.core.util.internal.logging.InternalLoggerFactory;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public abstract class PushMeterRegistry
extends MeterRegistry {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(PushMeterRegistry.class);
    private final PushRegistryConfig config;
    @Nullable
    private ScheduledExecutorService scheduledExecutorService;

    protected PushMeterRegistry(PushRegistryConfig pushRegistryConfig, Clock clock) {
        super(clock);
        pushRegistryConfig.requireValid();
        this.config = pushRegistryConfig;
    }

    protected abstract void publish();

    private void publishSafely() {
        try {
            this.publish();
        }
        catch (Throwable throwable) {
            logger.warn("Unexpected exception thrown while publishing metrics for " + this.getClass().getSimpleName(), throwable);
        }
    }

    @Deprecated
    public final void start() {
        this.start(Executors.defaultThreadFactory());
    }

    public void start(ThreadFactory threadFactory) {
        if (this.scheduledExecutorService != null) {
            this.stop();
        }
        if (this.config.enabled()) {
            logger.info("publishing metrics for " + this.getClass().getSimpleName() + " every " + TimeUtils.format(this.config.step()));
            this.scheduledExecutorService = Executors.newSingleThreadScheduledExecutor(threadFactory);
            long l2 = this.config.step().toMillis();
            long l3 = l2 - this.clock.wallTime() % l2 + 1L;
            this.scheduledExecutorService.scheduleAtFixedRate(this::publishSafely, l3, l2, TimeUnit.MILLISECONDS);
        }
    }

    public void stop() {
        if (this.scheduledExecutorService != null) {
            this.scheduledExecutorService.shutdown();
            this.scheduledExecutorService = null;
        }
    }

    @Override
    public void close() {
        if (this.config.enabled()) {
            this.publishSafely();
        }
        this.stop();
        super.close();
    }
}

