/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.micrometer.core.instrument.simple;

import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.AbstractDistributionSummary;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.AbstractTimer;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Clock;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Counter;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.DistributionSummary;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.FunctionCounter;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.FunctionTimer;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Gauge;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.LongTaskTimer;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Measurement;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Meter;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.MeterRegistry;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Timer;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.cumulative.CumulativeCounter;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.cumulative.CumulativeDistributionSummary;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.cumulative.CumulativeFunctionCounter;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.cumulative.CumulativeFunctionTimer;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.cumulative.CumulativeTimer;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.distribution.HistogramGauges;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.distribution.pause.PauseDetector;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.internal.DefaultGauge;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.internal.DefaultLongTaskTimer;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.internal.DefaultMeter;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.simple.SimpleConfig;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.step.StepCounter;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.step.StepDistributionSummary;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.step.StepFunctionCounter;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.step.StepFunctionTimer;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.step.StepTimer;
import com.contrastsecurity.thirdparty.io.micrometer.core.lang.Nullable;
import java.util.concurrent.TimeUnit;
import java.util.function.ToDoubleFunction;
import java.util.function.ToLongFunction;

public class SimpleMeterRegistry
extends MeterRegistry {
    private final SimpleConfig config;

    public SimpleMeterRegistry() {
        this(SimpleConfig.DEFAULT, Clock.SYSTEM);
    }

    public SimpleMeterRegistry(SimpleConfig simpleConfig, Clock clock) {
        super(clock);
        simpleConfig.requireValid();
        this.config = simpleConfig;
    }

    @Override
    protected DistributionSummary newDistributionSummary(Meter.Id id, DistributionStatisticConfig distributionStatisticConfig, double d2) {
        AbstractDistributionSummary abstractDistributionSummary;
        DistributionStatisticConfig distributionStatisticConfig2 = distributionStatisticConfig.merge(DistributionStatisticConfig.builder().expiry(this.config.step()).build());
        switch (this.config.mode()) {
            case CUMULATIVE: {
                abstractDistributionSummary = new CumulativeDistributionSummary(id, this.clock, distributionStatisticConfig2, d2, false);
                break;
            }
            default: {
                abstractDistributionSummary = new StepDistributionSummary(id, this.clock, distributionStatisticConfig2, d2, this.config.step().toMillis(), false);
            }
        }
        HistogramGauges.registerWithCommonFormat(abstractDistributionSummary, (MeterRegistry)this);
        return abstractDistributionSummary;
    }

    @Override
    protected Meter newMeter(Meter.Id id, Meter.Type type, Iterable<Measurement> iterable) {
        return new DefaultMeter(id, type, iterable);
    }

    @Override
    protected Timer newTimer(Meter.Id id, DistributionStatisticConfig distributionStatisticConfig, PauseDetector pauseDetector) {
        AbstractTimer abstractTimer;
        DistributionStatisticConfig distributionStatisticConfig2 = distributionStatisticConfig.merge(DistributionStatisticConfig.builder().expiry(this.config.step()).build());
        switch (this.config.mode()) {
            case CUMULATIVE: {
                abstractTimer = new CumulativeTimer(id, this.clock, distributionStatisticConfig2, pauseDetector, this.getBaseTimeUnit(), false);
                break;
            }
            default: {
                abstractTimer = new StepTimer(id, this.clock, distributionStatisticConfig2, pauseDetector, this.getBaseTimeUnit(), this.config.step().toMillis(), false);
            }
        }
        HistogramGauges.registerWithCommonFormat(abstractTimer, (MeterRegistry)this);
        return abstractTimer;
    }

    @Override
    protected <T> Gauge newGauge(Meter.Id id, @Nullable T t2, ToDoubleFunction<T> toDoubleFunction) {
        return new DefaultGauge<T>(id, t2, toDoubleFunction);
    }

    @Override
    protected Counter newCounter(Meter.Id id) {
        switch (this.config.mode()) {
            case CUMULATIVE: {
                return new CumulativeCounter(id);
            }
        }
        return new StepCounter(id, this.clock, this.config.step().toMillis());
    }

    @Override
    protected LongTaskTimer newLongTaskTimer(Meter.Id id, DistributionStatisticConfig distributionStatisticConfig) {
        DefaultLongTaskTimer defaultLongTaskTimer = new DefaultLongTaskTimer(id, this.clock, this.getBaseTimeUnit(), distributionStatisticConfig, false);
        HistogramGauges.registerWithCommonFormat(defaultLongTaskTimer, (MeterRegistry)this);
        return defaultLongTaskTimer;
    }

    @Override
    protected <T> FunctionTimer newFunctionTimer(Meter.Id id, T t2, ToLongFunction<T> toLongFunction, ToDoubleFunction<T> toDoubleFunction, TimeUnit timeUnit) {
        switch (this.config.mode()) {
            case CUMULATIVE: {
                return new CumulativeFunctionTimer<T>(id, t2, toLongFunction, toDoubleFunction, timeUnit, this.getBaseTimeUnit());
            }
        }
        return new StepFunctionTimer<T>(id, this.clock, this.config.step().toMillis(), t2, toLongFunction, toDoubleFunction, timeUnit, this.getBaseTimeUnit());
    }

    @Override
    protected <T> FunctionCounter newFunctionCounter(Meter.Id id, T t2, ToDoubleFunction<T> toDoubleFunction) {
        switch (this.config.mode()) {
            case CUMULATIVE: {
                return new CumulativeFunctionCounter<T>(id, t2, toDoubleFunction);
            }
        }
        return new StepFunctionCounter<T>(id, this.clock, this.config.step().toMillis(), t2, toDoubleFunction);
    }

    @Override
    protected TimeUnit getBaseTimeUnit() {
        return TimeUnit.SECONDS;
    }

    @Override
    protected DistributionStatisticConfig defaultHistogramConfig() {
        return DistributionStatisticConfig.builder().expiry(this.config.step()).build().merge(DistributionStatisticConfig.DEFAULT);
    }
}

