/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.micrometer.core.instrument.step;

import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Clock;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Measurement;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Statistic;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.step.StepDouble;
import java.util.concurrent.atomic.DoubleAdder;
import java.util.function.Supplier;

class StepMeasurement
extends Measurement {
    private final StepDouble value;
    private final DoubleAdder lastCount = new DoubleAdder();
    private final Supplier<Double> f;

    public StepMeasurement(Supplier<Double> supplier, Statistic statistic, Clock clock, long l2) {
        super(supplier, statistic);
        this.f = supplier;
        this.value = new StepDouble(clock, l2);
    }

    @Override
    public double getValue() {
        double d2 = this.f.get();
        double d3 = Math.max(0.0, d2 - this.lastCount.sum());
        this.lastCount.add(d3);
        this.value.getCurrent().add(d3);
        return (Double)this.value.poll();
    }
}

