/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.micrometer.core.instrument.step;

import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Clock;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;

public class StepTuple2<T1, T2> {
    private final Clock clock;
    private final long stepMillis;
    private AtomicLong lastInitPos;
    private final T1 t1NoValue;
    private final T2 t2NoValue;
    private final Supplier<T1> t1Supplier;
    private final Supplier<T2> t2Supplier;
    private volatile T1 t1Previous;
    private volatile T2 t2Previous;

    public StepTuple2(Clock clock, long l2, T1 T1, T2 T2, Supplier<T1> supplier, Supplier<T2> supplier2) {
        this.clock = clock;
        this.stepMillis = l2;
        this.t1NoValue = T1;
        this.t2NoValue = T2;
        this.t1Supplier = supplier;
        this.t2Supplier = supplier2;
        this.t1Previous = T1;
        this.t2Previous = T2;
        this.lastInitPos = new AtomicLong(clock.wallTime() / l2);
    }

    private void rollCount(long l2) {
        long l3 = l2 / this.stepMillis;
        long l4 = this.lastInitPos.get();
        if (l4 < l3 && this.lastInitPos.compareAndSet(l4, l3)) {
            this.t1Previous = l4 == l3 - 1L ? this.t1Supplier.get() : this.t1NoValue;
            this.t2Previous = l4 == l3 - 1L ? this.t2Supplier.get() : this.t2NoValue;
        }
    }

    public T1 poll1() {
        this.rollCount(this.clock.wallTime());
        return this.t1Previous;
    }

    public T2 poll2() {
        this.rollCount(this.clock.wallTime());
        return this.t2Previous;
    }
}

