/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.micrometer.core.instrument.util;

import java.util.AbstractList;
import java.util.List;

public abstract class AbstractPartition<T>
extends AbstractList<List<T>> {
    final List<T> delegate;
    final int partitionSize;
    final int partitionCount;

    protected AbstractPartition(List<T> list, int n2) {
        if (list == null) {
            throw new NullPointerException("delegate == null");
        }
        this.delegate = list;
        if (n2 < 1) {
            throw new IllegalArgumentException("partitionSize < 1");
        }
        this.partitionSize = n2;
        this.partitionCount = AbstractPartition.partitionCount(list, n2);
    }

    @Override
    public List<T> get(int n2) {
        int n3 = n2 * this.partitionSize;
        int n4 = Math.min(n3 + this.partitionSize, this.delegate.size());
        return this.delegate.subList(n3, n4);
    }

    @Override
    public int size() {
        return this.partitionCount;
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    static <T> int partitionCount(List<T> list, int n2) {
        int n3 = list.size() / n2;
        return list.size() % n2 == 0 ? n3 : n3 + 1;
    }
}

